/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.protocol.rest.RESTDeploymentAppender;
import org.jboss.arquillian.protocol.servlet5.Processor;
import org.jboss.arquillian.protocol.servlet5.ServletUtil;
import org.jboss.arquillian.protocol.servlet5.arq514hack.descriptors.api.application.ApplicationDescriptor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

public class RESTDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        JavaArchive protocol = new RESTDeploymentAppender().createAuxiliaryArchive();
        Archive applicationArchive = testDeployment.getApplicationArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        Processor processor = new Processor(testDeployment, processors);
        if (Validate.isArchiveOfType(EnterpriseArchive.class, (Archive)applicationArchive)) {
            return this.handleArchive((EnterpriseArchive)applicationArchive.as(EnterpriseArchive.class), auxiliaryArchives, protocol, processor, testDeployment);
        }
        if (Validate.isArchiveOfType(WebArchive.class, (Archive)applicationArchive)) {
            return this.handleArchive((WebArchive)applicationArchive.as(WebArchive.class), auxiliaryArchives, protocol, processor);
        }
        if (Validate.isArchiveOfType(JavaArchive.class, (Archive)applicationArchive)) {
            return this.handleArchive((JavaArchive)applicationArchive.as(JavaArchive.class), auxiliaryArchives, protocol, processor);
        }
        throw new IllegalArgumentException(RESTDeploymentPackager.class.getName() + " can not handle archive of type " + applicationArchive.getClass().getName());
    }

    private Archive<?> handleArchive(WebArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, JavaArchive protocol, Processor processor) {
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        if (protocol != null) {
            applicationArchive.addAsLibrary((Archive)protocol);
        }
        processor.process((Archive)applicationArchive);
        return applicationArchive;
    }

    private Archive<?> handleArchive(JavaArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, JavaArchive protocol, Processor processor) {
        return this.handleArchive((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)("test-" + UUID.randomUUID().toString() + ".war"))).addAsLibrary((Archive)applicationArchive), auxiliaryArchives, protocol, processor);
    }

    private Archive<?> handleArchive(EnterpriseArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, JavaArchive protocol, Processor processor, TestDeployment testDeployment) {
        Map applicationArchiveWars = applicationArchive.getContent(Filters.include((String)".*\\.war"));
        if (applicationArchiveWars.size() == 1) {
            ArchivePath warPath = (ArchivePath)applicationArchiveWars.keySet().iterator().next();
            try {
                this.handleArchive((WebArchive)applicationArchive.getAsType(WebArchive.class, warPath), new ArrayList(), protocol, processor);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Can not manipulate war's that are not of type " + WebArchive.class, e);
            }
        } else if (applicationArchiveWars.size() > 1) {
            Archive archiveToTest = testDeployment.getArchiveForEnrichment();
            if (archiveToTest == null) {
                throw new UnsupportedOperationException("Multiple WebArchives found in " + applicationArchive.getName() + ". Can not determine which to enrich");
            }
            if (!archiveToTest.getName().endsWith(".war")) {
                throw new UnsupportedOperationException("Archive to test is not a WebArchive!");
            }
            this.handleArchive((WebArchive)archiveToTest.as(WebArchive.class), new ArrayList(), protocol, processor);
        } else {
            Archive<?> wrappedWar = this.handleArchive(protocol, new ArrayList(), null, processor);
            applicationArchive.addAsModule(wrappedWar);
            if (applicationArchive.contains(ServletUtil.APPLICATION_XML_PATH)) {
                ApplicationDescriptor applicationXml = (ApplicationDescriptor)Descriptors.importAs(ApplicationDescriptor.class).fromStream(applicationArchive.get(ServletUtil.APPLICATION_XML_PATH).getAsset().openStream());
                applicationXml.webModule(wrappedWar.getName(), ServletUtil.calculateContextRoot((String)wrappedWar.getName()));
                applicationArchive.delete(ServletUtil.APPLICATION_XML_PATH);
                applicationArchive.setApplicationXML((Asset)new StringAsset(applicationXml.exportAsString()));
            }
        }
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        return applicationArchive;
    }
}

