/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.rest;

import java.net.URI;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.rest.RESTURIHandler;
import org.jboss.arquillian.protocol.servlet5.ServletMethodExecutor;
import org.jboss.arquillian.protocol.servlet5.ServletProtocolConfiguration;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

public class RESTMethodExecutor
extends ServletMethodExecutor {
    public static final String ARQUILLIAN_REST_NAME = "ArquillianRESTRunnerEE9";
    public static final String ARQUILLIAN_REST_MAPPING = "/ArquillianRESTRunnerEE9";

    public RESTMethodExecutor(ServletProtocolConfiguration config, Collection<HTTPContext> contexts, CommandCallback callback) {
        if (config == null) {
            throw new IllegalArgumentException("ServletProtocolConfiguration must be specified");
        }
        if (contexts == null || contexts.size() == 0) {
            throw new IllegalArgumentException("HTTPContext must be specified");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback must be specified");
        }
        this.config = config;
        this.uriHandler = new RESTURIHandler(config, contexts);
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor must be specified");
        }
        URI targetBaseURI = this.uriHandler.locateTestServlet(testMethodExecutor.getMethod());
        Class<?> testClass = testMethodExecutor.getInstance().getClass();
        Timer eventTimer = null;
        ReentrantLock timerLock = new ReentrantLock();
        AtomicBoolean isCanceled = new AtomicBoolean();
        try {
            String urlEncodedMethodName = URLEncoder.encode(testMethodExecutor.getMethodName(), "UTF-8");
            String url = targetBaseURI.toASCIIString() + "/ArquillianRESTRunnerEE9?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + urlEncodedMethodName;
            String eventUrl = targetBaseURI.toASCIIString() + "/ArquillianRESTRunnerEE9?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + urlEncodedMethodName + "&cmd=event";
            eventTimer = this.createCommandServicePullTimer(eventUrl, timerLock, isCanceled);
            TestResult testResult = (TestResult)this.executeWithRetry(url, TestResult.class);
            return testResult;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error launching test " + testClass.getName() + " " + testMethodExecutor.getMethod(), e);
        }
        finally {
            if (eventTimer != null) {
                eventTimer.cancel();
                timerLock.lock();
                try {
                    isCanceled.set(true);
                }
                finally {
                    timerLock.unlock();
                }
            }
        }
    }
}

