/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.rest.runner;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.util.TestRunners;
import org.jboss.arquillian.protocol.rest.runner.SecurityActions;
import org.jboss.arquillian.test.spi.TestResult;

@Path(value="")
public class RESTTestRunner {
    public static final String PARA_METHOD_NAME = "methodName";
    public static final String PARA_CLASS_NAME = "className";
    public static final String PARA_OUTPUT_MODE = "outputMode";
    public static final String PARA_CMD_NAME = "cmd";
    public static final String OUTPUT_MODE_SERIALIZED = "serializedObject";
    public static final String OUTPUT_MODE_HTML = "html";
    public static final String CMD_NAME_TEST = "test";
    public static final String CMD_NAME_EVENT = "event";
    static ConcurrentHashMap<String, Command<?>> events = new ConcurrentHashMap();
    static ThreadLocal<String> currentCall = new ThreadLocal();

    @POST
    public Response doPost(@QueryParam(value="outputMode") String outputMode, @QueryParam(value="className") String className, @QueryParam(value="methodName") String methodName, @QueryParam(value="cmd") String cmd, byte[] cmdObject) throws WebApplicationException, IOException {
        return this.execute(outputMode, className, methodName, cmd, cmdObject);
    }

    @GET
    public Response doGet(@QueryParam(value="outputMode") String outputMode, @QueryParam(value="className") String className, @QueryParam(value="methodName") String methodName, @QueryParam(value="cmd") String cmd) throws WebApplicationException, IOException {
        return this.execute(outputMode, className, methodName, cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response execute(String outputMode, String className, String methodName, String cmd, byte[] cmdObject) throws WebApplicationException, IOException {
        Response.ResponseBuilder response;
        block13: {
            if (outputMode == null) {
                outputMode = OUTPUT_MODE_HTML;
            }
            if (cmd == null) {
                cmd = CMD_NAME_TEST;
            }
            response = Response.ok();
            try {
                if (className == null) {
                    throw new IllegalArgumentException("className must be specified");
                }
                if (methodName == null) {
                    throw new IllegalArgumentException("methodName must be specified");
                }
                currentCall.set(className + methodName);
                if (CMD_NAME_TEST.equals(cmd)) {
                    this.executeTest(response, outputMode, className, methodName);
                    break block13;
                }
                if (CMD_NAME_EVENT.equals(cmd)) {
                    this.executeEvent(cmdObject, response, className, methodName);
                    break block13;
                }
                throw new RuntimeException("Unknown value for parametercmd: " + cmd);
            }
            catch (Exception e) {
                if (OUTPUT_MODE_SERIALIZED.equalsIgnoreCase(outputMode)) {
                    this.writeObject(this.createFailedResult(e), response);
                } else {
                    response.status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
                }
            }
            finally {
                currentCall.remove();
            }
        }
        return response.build();
    }

    public void executeTest(Response.ResponseBuilder response, String outputMode, String className, String methodName) throws ClassNotFoundException, IOException {
        Class<?> testClass = SecurityActions.getThreadContextClassLoader().loadClass(className);
        TestRunner runner = TestRunners.getTestRunner();
        TestResult testResult = runner.execute(testClass, methodName);
        if (OUTPUT_MODE_SERIALIZED.equalsIgnoreCase(outputMode)) {
            this.writeObject(testResult, response);
        } else {
            response.type(MediaType.TEXT_HTML_TYPE);
            response.status(Response.Status.OK);
            StringBuilder buffer = new StringBuilder();
            buffer.append("<html>\n");
            buffer.append("<head><title>TCK Report</title></head>\n");
            buffer.append("<body>\n");
            buffer.append("<h2>Configuration</h2>\n");
            buffer.append("<table>\n");
            buffer.append("<tr>\n");
            buffer.append("<td><b>Method</b></td><td><b>Status</b></td>\n");
            buffer.append("</tr>\n");
            buffer.append("</table>\n");
            buffer.append("<h2>Tests</h2>\n");
            buffer.append("<table>\n");
            buffer.append("<tr>\n");
            buffer.append("<td><b>Method</b></td><td><b>Status</b></td>\n");
            buffer.append("</tr>\n");
            buffer.append("</table>\n");
            buffer.append("</body>\n");
            response.entity((Object)buffer.toString());
        }
    }

    public void executeEvent(byte[] cmdObject, Response.ResponseBuilder response, String className, String methodName) throws ClassNotFoundException, IOException {
        String eventKey = className + methodName;
        if (cmdObject != null && cmdObject.length > 0) {
            response.status(Response.Status.NO_CONTENT);
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(cmdObject));
            Command result = (Command)input.readObject();
            input.close();
            events.put(eventKey, result);
        } else if (events.containsKey(eventKey) && events.get(eventKey).getResult() == null) {
            response.status(Response.Status.OK);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(baos);
            output.writeObject(events.remove(eventKey));
            output.flush();
            response.type(MediaType.APPLICATION_OCTET_STREAM_TYPE);
            response.entity((Object)baos.toByteArray());
            output.close();
        } else {
            response.status(Response.Status.NO_CONTENT);
        }
    }

    private void writeObject(Object object, Response.ResponseBuilder response) {
        try {
            response.status(Response.Status.OK);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            response.type(MediaType.APPLICATION_OCTET_STREAM_TYPE);
            response.entity((Object)baos.toByteArray());
            oos.close();
        }
        catch (Exception e) {
            try {
                response.status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
            }
            catch (Exception e2) {
                throw new RuntimeException("Could not write to output", e2);
            }
        }
    }

    private TestResult createFailedResult(Throwable throwable) {
        return TestResult.failed((Throwable)throwable);
    }
}

