/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet_3;

import java.util.Collection;
import org.jboss.arquillian.protocol.servlet_3.ProtocolDeploymentAppender;
import org.jboss.arquillian.spi.DeploymentPackager;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class ServletProtocolDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment) {
        Archive<?> protocol = new ProtocolDeploymentAppender().createAuxiliaryArchive();
        Archive applicationArchive = testDeployment.getApplicationArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((EnterpriseArchive)EnterpriseArchive.class.cast(applicationArchive), auxiliaryArchives, protocol);
        }
        if (WebArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((WebArchive)WebArchive.class.cast(applicationArchive), auxiliaryArchives, protocol);
        }
        if (JavaArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(applicationArchive), auxiliaryArchives, protocol);
        }
        throw new IllegalArgumentException(ServletProtocolDeploymentPackager.class.getName() + " can not handle archive of type " + applicationArchive.getClass().getName());
    }

    private Archive<?> handleArchive(WebArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, Archive<?> protocol) {
        return ((WebArchive)applicationArchive.addLibraries(auxiliaryArchives.toArray(new Archive[0]))).addLibrary(protocol);
    }

    private Archive<?> handleArchive(JavaArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, Archive<?> protocol) {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test.war")).addLibraries(new Archive[]{applicationArchive, protocol})).addLibraries(auxiliaryArchives.toArray(new Archive[0]));
    }

    private Archive<?> handleArchive(EnterpriseArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, Archive<?> protocol) {
        ((EnterpriseArchive)applicationArchive.addModule(((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test.war")).addLibrary(protocol))).addLibraries(auxiliaryArchives.toArray(new Archive[0]));
        return applicationArchive;
    }
}

