/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet5.test;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.protocol.servlet5.runner.ServletCommandService;
import org.jboss.arquillian.test.spi.TestResult;

public class MockTestRunner
implements TestRunner {
    public static TestResult wantedResults;
    public static List<Command<?>> commands;
    public static List<Object> commandResults;
    public static List<TestRequest> testRequests;

    public static void add(Command<?> command) {
        commands.add(command);
    }

    public static void add(TestResult wantedTestResult) {
        wantedResults = wantedTestResult;
    }

    public static void clear() {
        wantedResults = null;
        commands.clear();
        commandResults.clear();
        testRequests.clear();
    }

    public TestResult execute(Class<?> testClass, String methodName) {
        testRequests.add(new TestRequest(testClass, methodName));
        for (Command<?> command : commands) {
            commandResults.add(new ServletCommandService().execute(command));
        }
        return wantedResults;
    }

    static {
        commands = new ArrayList();
        commandResults = new ArrayList<Object>();
        testRequests = new ArrayList<TestRequest>();
    }

    public static class TestRequest {
        private final Class<?> testClass;
        private final String methodName;

        public TestRequest(Class<?> testClass, String methodName) {
            this.testClass = testClass;
            this.methodName = methodName;
        }

        public Class<?> getTestClass() {
            return this.testClass;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

