/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import junit.framework.Assert;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.servlet.BaseServletProtocol;
import org.jboss.arquillian.protocol.servlet.ServletMethodExecutor;
import org.jboss.arquillian.protocol.servlet.ServletProtocolConfiguration;
import org.jboss.arquillian.protocol.servlet.test.TestCommandCallback;
import org.jboss.arquillian.protocol.servlet.v_2_5.ServletProtocol;
import org.junit.Test;

public class BaseServletProtocolTestCase {
    private BaseServletProtocol protocol = new BaseServletProtocol(){

        protected String getProtcolName() {
            return "Test";
        }

        public DeploymentPackager getPackager() {
            return null;
        }
    };

    @Test
    public void shouldFindTestServletInMetadata() throws Exception {
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        ServletMethodExecutor executor = this.protocol.getExecutor(config, new ProtocolMetaData().addContext((Object)new HTTPContext("127.0.0.1", 8080).add(new Servlet("ArquillianServletRunner", "test"))), (CommandCallback)new TestCommandCallback());
        Assert.assertEquals((String)"http://127.0.0.1:8080/test", (String)executor.getBaseURI().toString());
    }

    @Test
    public void shouldOverrideMetadata() throws Exception {
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        config.setHost("10.10.10.1");
        config.setPort(Integer.valueOf(90));
        ServletProtocol protocol = new ServletProtocol();
        ServletMethodExecutor executor = protocol.getExecutor(config, new ProtocolMetaData().addContext((Object)new HTTPContext("127.0.0.1", 8080).add(new Servlet("ArquillianServletRunner", "test"))), (CommandCallback)new TestCommandCallback());
        Assert.assertEquals((String)"http://10.10.10.1:90/test", (String)executor.getBaseURI().toString());
    }
}

