/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.net.URL;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.servlet.AbstractServerBase;
import org.jboss.arquillian.protocol.servlet.ServletMethodExecutor;
import org.jboss.arquillian.protocol.servlet.TestUtil;
import org.jboss.arquillian.protocol.servlet.test.MockTestRunner;
import org.jboss.arquillian.protocol.servlet.test.TestCommandCallback;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Assert;
import org.junit.Test;

public class ProtocolTestCase
extends AbstractServerBase {
    @Test
    public void shouldReturnTestResult() throws Exception {
        MockTestRunner.add(new TestResult(TestResult.Status.PASSED, null));
        ServletMethodExecutor executor = new ServletMethodExecutor(this.createBaseURL(), (CommandCallback)new TestCommandCallback());
        TestResult result = executor.invoke((TestMethodExecutor)new AbstractServerBase.MockTestExecutor());
        Assert.assertEquals((String)"Should have returned a passed test", (Object)MockTestRunner.wantedResults.getStatus(), (Object)result.getStatus());
        Assert.assertNull((String)"No Exception should have been thrown", (Object)result.getThrowable());
    }

    @Test
    public void shouldReturnThrownException() throws Exception {
        MockTestRunner.add(new TestResult(TestResult.Status.FAILED, new Exception().fillInStackTrace()));
        ServletMethodExecutor executor = new ServletMethodExecutor(this.createBaseURL(), (CommandCallback)new TestCommandCallback());
        TestResult result = executor.invoke((TestMethodExecutor)new AbstractServerBase.MockTestExecutor());
        Assert.assertEquals((String)"Should have returned a passed test", (Object)MockTestRunner.wantedResults.getStatus(), (Object)result.getStatus());
        Assert.assertNotNull((String)"Exception should have been thrown", (Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionWhenMissingTestClassParameter() throws Exception {
        URL url = this.createURL("serializedObject", null, null);
        TestResult result = (TestResult)TestUtil.execute(url);
        Assert.assertEquals((String)"Should have returned a passed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertTrue((String)"No Exception should have been thrown", (boolean)(result.getThrowable() instanceof IllegalArgumentException));
    }

    @Test
    public void shouldReturnExceptionWhenMissingMethodParameter() throws Exception {
        URL url = this.createURL("serializedObject", "org.my.test", null);
        TestResult result = (TestResult)TestUtil.execute(url);
        Assert.assertEquals((String)"Should have returned a passed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertTrue((String)"No Exception should have been thrown", (boolean)(result.getThrowable() instanceof IllegalArgumentException));
    }

    @Test
    public void shouldReturnExceptionWhenErrorLoadingClass() throws Exception {
        URL url = this.createURL("serializedObject", "org.my.test", "test");
        TestResult result = (TestResult)TestUtil.execute(url);
        Assert.assertEquals((String)"Should have returned a passed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertTrue((String)"No Exception should have been thrown", (boolean)(result.getThrowable() instanceof ClassNotFoundException));
    }
}

