/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

public class ServletMethodExecutor
implements ContainerMethodExecutor {
    public static final String ARQUILLIAN_SERVLET_NAME = "ArquillianServletRunner";
    public static final String ARQUILLIAN_SERVLET_MAPPING = "/ArquillianServletRunner";
    private URI baseURI;
    private CommandCallback callback;

    public ServletMethodExecutor(URI baseURI, CommandCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback must be specified");
        }
        this.baseURI = baseURI;
        this.callback = callback;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor must be specified");
        }
        Class<?> testClass = testMethodExecutor.getInstance().getClass();
        String url = this.baseURI.toASCIIString() + ARQUILLIAN_SERVLET_MAPPING + "?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + testMethodExecutor.getMethod().getName();
        final String eventUrl = this.baseURI.toASCIIString() + ARQUILLIAN_SERVLET_MAPPING + "?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + testMethodExecutor.getMethod().getName() + "&cmd=event";
        Timer eventTimer = null;
        try {
            eventTimer = new Timer();
            eventTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    block3: {
                        try {
                            Object o = ServletMethodExecutor.this.execute(eventUrl, Object.class, null);
                            if (o == null) break block3;
                            if (o instanceof Command) {
                                Command command = (Command)o;
                                ServletMethodExecutor.this.callback.fired(command);
                                ServletMethodExecutor.this.execute(eventUrl, Object.class, command);
                                break block3;
                            }
                            throw new RuntimeException("Recived a non " + Command.class.getName() + " object on event channel");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, 0L, 100L);
            TestResult testResult = this.executeWithRetry(url, TestResult.class);
            return testResult;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error launching test " + testClass.getName() + " " + testMethodExecutor.getMethod(), e);
        }
        finally {
            if (eventTimer != null) {
                eventTimer.cancel();
            }
        }
    }

    private <T> T executeWithRetry(String url, Class<T> type) throws Exception {
        long timeoutTime = System.currentTimeMillis() + 1000L;
        boolean interrupted = false;
        while (timeoutTime > System.currentTimeMillis()) {
            T o = this.execute(url, type, null);
            if (o != null) {
                return o;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        throw new IllegalStateException("Error launching request at " + url + ". No result returned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(String url, Class<T> returnType, Object requestObject) throws Exception {
        URLConnection connection = new URL(url).openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalStateException("Not an http connection! " + connection);
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setUseCaches(false);
        httpConnection.setDefaultUseCaches(false);
        httpConnection.setDoInput(true);
        try {
            if (requestObject != null) {
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(true);
                httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
            }
            if (requestObject != null) {
                ObjectOutputStream ous = new ObjectOutputStream(httpConnection.getOutputStream());
                try {
                    ous.writeObject(requestObject);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error sending request Object, " + requestObject, e2);
                }
                finally {
                    ous.flush();
                    ous.close();
                }
            }
            try {
                httpConnection.getResponseCode();
            }
            catch (ConnectException e) {
                T e2 = null;
                httpConnection.disconnect();
                return e2;
            }
            if (httpConnection.getResponseCode() == 200) {
                Object o;
                ObjectInputStream ois = new ObjectInputStream(httpConnection.getInputStream());
                try {
                    o = ois.readObject();
                }
                finally {
                    ois.close();
                }
                if (!returnType.isInstance(o)) {
                    throw new IllegalStateException("Error reading results, expected a " + returnType.getName() + " but got " + o);
                }
                T t = returnType.cast(o);
                return t;
            }
            if (httpConnection.getResponseCode() == 204) {
                T t = null;
                return t;
            }
            if (httpConnection.getResponseCode() != 404) {
                throw new IllegalStateException("Error launching test at " + url + ". " + "Got " + httpConnection.getResponseCode() + " (" + httpConnection.getResponseMessage() + ")");
            }
        }
        finally {
            httpConnection.disconnect();
        }
        return null;
    }
}

