/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet.runner;

import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner;

public class ServletCommandService
implements CommandService {
    private static long TIMEOUT = 10000L;

    public <T> T execute(Command<T> command) {
        String currentId = ServletTestRunner.currentCall.get();
        ServletTestRunner.events.put(currentId, command);
        long timeoutTime = System.currentTimeMillis() + TIMEOUT;
        while (timeoutTime > System.currentTimeMillis()) {
            Command<?> newCommand = ServletTestRunner.events.get(currentId);
            if (newCommand != null && newCommand.getResult() != null) {
                return (T)newCommand.getResult();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No command response within timeout of " + TIMEOUT + " ms.");
    }
}

