/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner;
import org.jboss.arquillian.protocol.servlet.test.MockTestRunner;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.junit.After;
import org.junit.Before;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;

public class AbstractServerBase {
    protected Server server;

    @Before
    public void setup() throws Exception {
        this.server = new Server(8181);
        Context root = new Context((HandlerContainer)this.server, "/arquillian-protocol", 1);
        root.addServlet(ServletTestRunner.class, "/ArquillianServletRunner");
        this.server.start();
    }

    @After
    public void cleanup() throws Exception {
        MockTestRunner.clear();
        this.server.stop();
    }

    protected URI createBaseURL() {
        return URI.create("http://localhost:" + this.server.getConnectors()[0].getPort() + "/arquillian-protocol");
    }

    protected URL createURL(String outputMode, String testClass, String methodName) {
        StringBuilder url = new StringBuilder(this.createBaseURL().toASCIIString() + "/ArquillianServletRunner");
        boolean first = true;
        if (outputMode != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("outputMode").append("=").append(outputMode);
        }
        if (testClass != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("className").append("=").append(testClass);
        }
        if (methodName != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("methodName").append("=").append(methodName);
        }
        try {
            return new URL(url.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create url", e);
        }
    }

    public static class MockTestExecutor
    implements TestMethodExecutor,
    Serializable {
        private static final long serialVersionUID = 1L;

        public void invoke(Object ... parameters) throws Throwable {
        }

        public Method getMethod() {
            try {
                return this.getClass().getMethod("getMethod", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find my own method ?? ");
            }
        }

        public Object getInstance() {
            return this;
        }
    }
}

