/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet.v_2_5;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.test.api.Testable;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.protocol.servlet.TestUtil;
import org.jboss.arquillian.protocol.servlet.arq514hack.descriptors.api.application.ApplicationDescriptor;
import org.jboss.arquillian.protocol.servlet.arq514hack.descriptors.api.web.WebAppDescriptor;
import org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner;
import org.jboss.arquillian.protocol.servlet.v_2_5.ServletProtocolDeploymentPackager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.formatter.Formatters;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.Assert;
import org.junit.Test;

public class ServletProtocolDeploymentPackagerTestCase {
    @Test
    public void shouldHandleJavaArchive() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment((Archive)ShrinkWrap.create(JavaArchive.class, (String)"applicationArchive.jar"), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"Verify that a defined JavaArchive using EE5 WebArchive protocol is build as EnterpriseArchive", (boolean)Validate.isArchiveOfType(EnterpriseArchive.class, (Archive)archive));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives EE Modules are placed in /", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        Assert.assertTrue((String)"Verify that the applicationArchive is placed in /", (boolean)archive.contains(ArchivePaths.create((String)"/applicationArchive.jar")));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleWebArchive() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"applicationArchive.war")).addClass(this.getClass()), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"verify that the ServletTestRunner was added to the archive", (boolean)archive.contains("/WEB-INF/classes/org/jboss/arquillian/protocol/servlet/runner/ServletTestRunner.class"));
        String webXmlContent = TestUtil.convertToString(archive.get("WEB-INF/web.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml", (boolean)webXmlContent.contains(ServletTestRunner.class.getName()));
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml with correct name", (boolean)webXmlContent.contains("servlet-name>ArquillianServletRunner"));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleWebArchiveWithWebXML() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"applicationArchive.war")).addClass(this.getClass())).setWebXML(this.createWebDescriptor()), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"verify that the ServletTestRunner was added to the archive", (boolean)archive.contains("/WEB-INF/classes/org/jboss/arquillian/protocol/servlet/runner/ServletTestRunner.class"));
        System.out.println(archive.toString((Formatter)Formatters.VERBOSE));
        String webXmlContent = TestUtil.convertToString(archive.get("WEB-INF/web.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml", (boolean)webXmlContent.contains(ServletTestRunner.class.getName()));
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml with correct name", (boolean)webXmlContent.contains("servlet-name>ArquillianServletRunner"));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleEnterpriseArchive() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment((Archive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear"), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"Verify that the protocol is placed in /", (boolean)archive.contains(ArchivePaths.create((String)"arquillian-protocol.war")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleEnterpriseArchiveWithApplicationXML() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).setApplicationXML(this.createApplicationDescriptor()), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /", (boolean)archive.contains(ArchivePaths.create((String)"arquillian-protocol.war")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        String applicationXmlContent = TestUtil.convertToString(archive.get("META-INF/application.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the arquillian-protocol.war was added to the application.xml", (boolean)applicationXmlContent.contains("<web-uri>arquillian-protocol.war</web-uri>"));
        Assert.assertTrue((String)"verify that the arquillian-protocol.war has correct context-root in application.xml", (boolean)applicationXmlContent.contains("<context-root>arquillian-protocol</context-root>"));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleEnterpriseArchiveWithWebArchive() throws Exception {
        WebArchive applicationWar = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"applicationArchive.war");
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule((Archive)applicationWar), this.createAuxiliaryArchives()), this.processors());
        Assert.assertFalse((String)"Verify that the auxiliaryArchives was not added", (boolean)archive.contains(ArchivePaths.create((String)"arquillian-protocol.war")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        String webXmlContent = TestUtil.convertToString(applicationWar.get("WEB-INF/web.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml of the existing web archive", (boolean)webXmlContent.contains(ServletTestRunner.class.getName()));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnUnknownArchiveType() throws Exception {
        new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment((Archive)ShrinkWrap.create(ResourceAdapterArchive.class), new ArrayList()), this.processors());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowExceptionOnEnterpriseArchiveWithMultipleWebArchive() throws Exception {
        new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule((Archive)ShrinkWrap.create(WebArchive.class))).addAsModule((Archive)ShrinkWrap.create(WebArchive.class)), this.createAuxiliaryArchives()), this.processors());
    }

    @Test
    public void shouldHandleEnterpriseArchiveWithMultipleWebArchiveAndOneMarkedWebArchive() throws Exception {
        WebArchive testableArchive = (WebArchive)Testable.archiveToTest((Archive)((Archive)ShrinkWrap.create(WebArchive.class)));
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule((Archive)testableArchive)).addAsModule((Archive)ShrinkWrap.create(WebArchive.class)), this.createAuxiliaryArchives()), this.processors());
        Assert.assertFalse((String)"Verify that the auxiliaryArchives was not added", (boolean)archive.contains(ArchivePaths.create((String)"arquillian-protocol.war")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        String webXmlContent = TestUtil.convertToString(testableArchive.get("WEB-INF/web.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml of the existing web archive", (boolean)webXmlContent.contains(ServletTestRunner.class.getName()));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowExceptionOnEnterpriseArchiveWithMultipleMarkedWebArchives() throws Exception {
        new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule(Testable.archiveToTest((Archive)((Archive)ShrinkWrap.create(WebArchive.class))))).addAsModule(Testable.archiveToTest((Archive)((Archive)ShrinkWrap.create(WebArchive.class)))), this.createAuxiliaryArchives()), this.processors());
    }

    private Collection<Archive<?>> createAuxiliaryArchives() {
        ArrayList archives = new ArrayList();
        archives.add((Archive<?>)ShrinkWrap.create(JavaArchive.class, (String)"auxiliaryArchive1.jar"));
        archives.add((Archive<?>)ShrinkWrap.create(JavaArchive.class, (String)"auxiliaryArchive2.jar"));
        return archives;
    }

    private Asset createWebDescriptor() {
        return new StringAsset(((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version("2.5").servlet("org.jboss.arquillian.test.TestServlet", new String[]{"/Test"}).exportAsString());
    }

    private Asset createApplicationDescriptor() {
        return new StringAsset(((ApplicationDescriptor)Descriptors.create(ApplicationDescriptor.class)).version("5").ejbModule("test.jar").exportAsString());
    }

    private Collection<ProtocolArchiveProcessor> processors() {
        ArrayList<ProtocolArchiveProcessor> pros = new ArrayList<ProtocolArchiveProcessor>();
        pros.add(new DummyProcessor());
        return pros;
    }

    private static class DummyProcessor
    implements ProtocolArchiveProcessor {
        public static boolean wasCalled = false;

        public DummyProcessor() {
            wasCalled = false;
        }

        public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
            wasCalled = true;
        }
    }
}

