/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner;
import org.jboss.arquillian.protocol.servlet.test.MockTestRunner;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.junit.After;
import org.junit.Before;

public class AbstractServerBase {
    private Server server;

    @Before
    public void setup() throws Exception {
        this.server = new Server(this.getAvailableLocalPort());
        ServletContextHandler root = new ServletContextHandler(1);
        root.setContextPath("/arquillian-protocol");
        root.addServlet(ServletTestRunner.class, "/ArquillianServletRunner");
        this.server.setHandler((Handler)root);
        this.server.start();
    }

    @After
    public void cleanup() throws Exception {
        MockTestRunner.clear();
        this.server.stop();
    }

    private int getAvailableLocalPort() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    protected Collection<HTTPContext> createContexts() {
        ArrayList<HTTPContext> context = new ArrayList<HTTPContext>();
        context.add(this.createContext());
        return context;
    }

    protected HTTPContext createContext() {
        URI baseURI = this.createBaseURL();
        HTTPContext context = new HTTPContext(baseURI.getHost(), baseURI.getPort());
        context.add(new Servlet("ArquillianServletRunner", baseURI.getPath()));
        return context;
    }

    protected URI createBaseURL() {
        return URI.create("http://localhost:" + this.server.getConnectors()[0].getPort() + "/arquillian-protocol");
    }

    protected URL createURL(String outputMode, String testClass, String methodName) {
        StringBuilder url = new StringBuilder(this.createBaseURL().toASCIIString() + "/ArquillianServletRunner");
        boolean first = true;
        if (outputMode != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("outputMode").append("=").append(outputMode);
        }
        if (testClass != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("className").append("=").append(testClass);
        }
        if (methodName != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("methodName").append("=").append(methodName);
        }
        try {
            return new URL(url.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create url", e);
        }
    }

    public static class MockTestExecutor
    implements TestMethodExecutor,
    Serializable {
        private static final long serialVersionUID = 1L;

        public void invoke(Object ... parameters) throws Throwable {
        }

        public String getMethodName() {
            return this.getMethod().getName();
        }

        public Method getMethod() {
            try {
                return this.getClass().getMethod("getMethod", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find my own method ?? ");
            }
        }

        public Object getInstance() {
            return this;
        }
    }
}

