/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet.v_3;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.test.api.Testable;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.protocol.servlet.TestUtil;
import org.jboss.arquillian.protocol.servlet.arq514hack.descriptors.api.application.ApplicationDescriptor;
import org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner;
import org.jboss.arquillian.protocol.servlet.v_3.ServletProtocolDeploymentPackager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.Assert;
import org.junit.Test;

public class ServletProtocolDeploymentPackagerTestCase {
    @Test
    public void shouldHandleJavaArchive() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment((Archive)ShrinkWrap.create(JavaArchive.class, (String)"applicationArchive.jar"), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"Verify that a defined JavaArchive using EE6 JavaArchive protocol is build as WebArchive", (boolean)Validate.isArchiveOfType(WebArchive.class, (Archive)archive));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /WEB-INF/lib", (boolean)archive.contains(ArchivePaths.create((String)"/WEB-INF/lib/arquillian-protocol.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /WEB-INF/lib", (boolean)archive.contains(ArchivePaths.create((String)"/WEB-INF/lib/auxiliaryArchive2.jar")));
        Assert.assertTrue((String)"Verify that the applicationArchive is placed in /WEB-INF/lib", (boolean)archive.contains(ArchivePaths.create((String)"/WEB-INF/lib/applicationArchive.jar")));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleWebArchive() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment((Archive)ShrinkWrap.create(WebArchive.class, (String)"applicationArchive.war"), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"Verify that a defined WebArchive using EE6 JavaArchive protocol is build as WebArchive", (boolean)Validate.isArchiveOfType(WebArchive.class, (Archive)archive));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /WEB-INF/lib", (boolean)archive.contains(ArchivePaths.create((String)"/WEB-INF/lib/arquillian-protocol.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /WEB-INF/lib", (boolean)archive.contains(ArchivePaths.create((String)"/WEB-INF/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /WEB-INF/lib", (boolean)archive.contains(ArchivePaths.create((String)"/WEB-INF/lib/auxiliaryArchive2.jar")));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleEnterpriseArchive() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment((Archive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear"), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /", (boolean)archive.contains(ArchivePaths.create((String)JarNameProcessor.jarName)));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleEnterpriseArchiveWithApplicationXML() throws Exception {
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).setApplicationXML(this.createApplicationDescriptor()), this.createAuxiliaryArchives()), this.processors());
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /", (boolean)archive.contains(ArchivePaths.create((String)JarNameProcessor.jarName)));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        String applicationXmlContent = TestUtil.convertToString(archive.get("META-INF/application.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the arquillian-protocol.war was added to the application.xml", (boolean)applicationXmlContent.contains(String.format("<web-uri>%s</web-uri>", JarNameProcessor.jarName)));
        Assert.assertTrue((String)"verify that the arquillian-protocol.war has correct context-root in application.xml", (boolean)applicationXmlContent.contains(String.format("<context-root>%s</context-root>", JarNameProcessor.jarName.replaceFirst(".war$", ""))));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test
    public void shouldHandleEnterpriseArchiveWithWebArchive() throws Exception {
        WebArchive applicationWar = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"applicationArchive.war");
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule((Archive)applicationWar), this.createAuxiliaryArchives()), this.processors());
        Assert.assertFalse((String)"Verify that the auxiliaryArchives was not added", (boolean)archive.contains(ArchivePaths.create((String)"arquillian-protocol.war")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        String webXmlContent = TestUtil.convertToString(applicationWar.get("WEB-INF/lib/arquillian-protocol.jar/META-INF/web-fragment.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml of the existing web archive", (boolean)webXmlContent.contains(ServletTestRunner.class.getName()));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnUnknownArchiveType() throws Exception {
        new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment((Archive)ShrinkWrap.create(ResourceAdapterArchive.class), new ArrayList()), this.processors());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowExceptionOnEnterpriseArchiveWithMultipleWebArchive() throws Exception {
        new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule((Archive)ShrinkWrap.create(WebArchive.class))).addAsModule((Archive)ShrinkWrap.create(WebArchive.class)), this.createAuxiliaryArchives()), this.processors());
    }

    @Test
    public void shouldHandleEnterpriseArchiveWithMultipleWebArchiveAndOneMarkedWebArchive() throws Exception {
        WebArchive testableArchive = (WebArchive)Testable.archiveToTest((Archive)((WebArchive)ShrinkWrap.create(WebArchive.class)));
        Archive archive = new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule((Archive)testableArchive)).addAsModule((Archive)ShrinkWrap.create(WebArchive.class)), this.createAuxiliaryArchives()), this.processors());
        Assert.assertFalse((String)"Verify that the auxiliaryArchives was not added", (boolean)archive.contains(ArchivePaths.create((String)"arquillian-protocol.war")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive1.jar")));
        Assert.assertTrue((String)"Verify that the auxiliaryArchives are placed in /lib", (boolean)archive.contains(ArchivePaths.create((String)"/lib/auxiliaryArchive2.jar")));
        String webXmlContent = TestUtil.convertToString(testableArchive.get("WEB-INF/lib/arquillian-protocol.jar/META-INF/web-fragment.xml").getAsset().openStream());
        Assert.assertTrue((String)"verify that the ServletTestRunner servlet was added to the web.xml of the existing web archive", (boolean)webXmlContent.contains(ServletTestRunner.class.getName()));
        Assert.assertTrue((String)"Verify protocol Processor SPI was called", (boolean)DummyProcessor.wasCalled);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowExceptionOnEnterpriseArchiveWithMultipleMarkedWebArchives() throws Exception {
        new ServletProtocolDeploymentPackager().generateDeployment(new TestDeployment(((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"applicationArchive.ear")).addAsModule(Testable.archiveToTest((Archive)((WebArchive)ShrinkWrap.create(WebArchive.class))))).addAsModule(Testable.archiveToTest((Archive)((WebArchive)ShrinkWrap.create(WebArchive.class)))), this.createAuxiliaryArchives()), this.processors());
    }

    private Collection<Archive<?>> createAuxiliaryArchives() {
        ArrayList archives = new ArrayList();
        archives.add((Archive)ShrinkWrap.create(JavaArchive.class, (String)"auxiliaryArchive1.jar"));
        archives.add((Archive)ShrinkWrap.create(JavaArchive.class, (String)"auxiliaryArchive2.jar"));
        return archives;
    }

    private Asset createApplicationDescriptor() {
        return new StringAsset(((ApplicationDescriptor)Descriptors.create(ApplicationDescriptor.class)).version("6").ejbModule("test.jar").exportAsString());
    }

    private Collection<ProtocolArchiveProcessor> processors() {
        ArrayList<ProtocolArchiveProcessor> pros = new ArrayList<ProtocolArchiveProcessor>();
        pros.add(new DummyProcessor());
        pros.add(new JarNameProcessor());
        return pros;
    }

    private static class JarNameProcessor
    implements ProtocolArchiveProcessor {
        static String jarName;

        private JarNameProcessor() {
        }

        public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
            jarName = protocolArchive.getName();
        }
    }

    private static class DummyProcessor
    implements ProtocolArchiveProcessor {
        public static boolean wasCalled = false;

        public DummyProcessor() {
            wasCalled = false;
        }

        public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
            wasCalled = true;
        }
    }
}

