/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.lang.reflect.Field;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.servlet.AbstractServerBase;
import org.jboss.arquillian.protocol.servlet.ServletMethodExecutor;
import org.jboss.arquillian.protocol.servlet.ServletProtocolConfiguration;
import org.jboss.arquillian.protocol.servlet.runner.ServletCommandService;
import org.jboss.arquillian.protocol.servlet.test.MockTestRunner;
import org.jboss.arquillian.protocol.servlet.test.TestCommandCallback;
import org.jboss.arquillian.protocol.servlet.test.TestIntegerCommand;
import org.jboss.arquillian.protocol.servlet.test.TestStringCommand;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Assert;
import org.junit.Test;

public class ServletCommandServiceTestCase
extends AbstractServerBase {
    @Test
    public void shouldBeAbleToTransfereCommand() throws Exception {
        Object[] results = new Object[]{"Wee", 100};
        MockTestRunner.add(TestResult.passed());
        MockTestRunner.add(new TestStringCommand());
        MockTestRunner.add(new TestIntegerCommand());
        ServletMethodExecutor executor = new ServletMethodExecutor(new ServletProtocolConfiguration(), this.createContexts(), (CommandCallback)new TestCommandCallback(results));
        TestResult result = executor.invoke((TestMethodExecutor)new AbstractServerBase.MockTestExecutor());
        Assert.assertEquals((String)"Should have returned a passed test", (Object)MockTestRunner.wantedResults.getStatus(), (Object)result.getStatus());
        Assert.assertNull((String)"Exception should have been thrown", (Object)result.getThrowable());
        Assert.assertEquals((String)"Should have returned command", (Object)results[0], (Object)MockTestRunner.commandResults.get(0));
        Assert.assertEquals((String)"Should have returned command", (Object)results[1], (Object)MockTestRunner.commandResults.get(1));
    }

    @Test
    public void shouldDisableCommandService() throws Exception {
        Field f = ServletCommandService.class.getDeclaredField("TIMEOUT");
        f.setAccessible(true);
        f.set(null, 500);
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        config.setPullInMilliSeconds(Integer.valueOf(0));
        Object[] results = new Object[]{"Wee", 100};
        MockTestRunner.add(TestResult.failed(null));
        MockTestRunner.add(new TestStringCommand());
        ServletMethodExecutor executor = new ServletMethodExecutor(config, this.createContexts(), (CommandCallback)new TestCommandCallback(results));
        TestResult result = executor.invoke((TestMethodExecutor)new AbstractServerBase.MockTestExecutor());
        Assert.assertEquals((String)"Should have returned a passed test", (Object)MockTestRunner.wantedResults.getStatus(), (Object)result.getStatus());
        Assert.assertNotNull((String)"Exception should have been thrown", (Object)result.getThrowable());
        Assert.assertTrue((String)"Timeout exception should have been thrown", (boolean)result.getThrowable().getMessage().contains("timeout"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfNoConfig() throws Exception {
        new ServletMethodExecutor(null, this.createContexts(), (CommandCallback)new TestCommandCallback(new Object[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfNoContexts() {
        new ServletMethodExecutor(new ServletProtocolConfiguration(), null, (CommandCallback)new TestCommandCallback(new Object[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfNoCallback() throws Exception {
        new ServletMethodExecutor(new ServletProtocolConfiguration(), this.createContexts(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfNoExecutor() throws Exception {
        ServletMethodExecutor executor = new ServletMethodExecutor(new ServletProtocolConfiguration(), this.createContexts(), (CommandCallback)new TestCommandCallback(new Object[0]));
        executor.invoke(null);
    }
}

