/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testng.container;

import java.lang.reflect.Method;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.arquillian.testng.container.TestNGTestRunner;
import org.junit.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestNGTestRunnerTestCase
extends Arquillian {
    @org.junit.Test
    public void shouldReturnPassedTest() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(TestNGTestRunnerTestCase.class, "shouldProvidePassingTestToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }

    @org.junit.Test
    public void shouldReturnExceptionOnPassedTest() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(TestNGTestRunnerTestCase.class, "shouldProvideExpectedExceptionToRunner");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(IllegalArgumentException.class, result.getThrowable().getClass());
    }

    @org.junit.Test
    public void shouldBeAbleToUseOtherDataProviders() throws Exception {
        TestNGTestRunner runner = new TestNGTestRunner();
        TestResult result = runner.execute(TestNGTestRunnerTestCase.class, "shouldBeAbleToUseOtherDataProviders");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldProvideExpectedExceptionToRunner() throws Exception {
        throw new IllegalArgumentException();
    }

    @Test
    public void shouldProvidePassingTestToRunner() throws Exception {
        Assert.assertTrue((boolean)true);
    }

    @DataProvider(name="xx")
    public static Object[][] getCurrentMethod(Method m) {
        return new Object[][]{{m}};
    }

    @Test(dataProvider="xx")
    public void shouldBeAbleToUseOtherDataProviders(Method m) throws Exception {
        Assert.assertNotNull((Object)m);
    }
}

