/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testng.standalone;

import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.Test;

public class LocalTestMethodExecutor {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @TestScoped
    private InstanceProducer<TestResult> testResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Observes Test event) throws Exception {
        TestResult result = TestResult.passed();
        try {
            event.getTestMethodExecutor().invoke(this.enrichArguments(event.getTestMethod(), ((ServiceLoader)this.serviceLoader.get()).all(TestEnricher.class)));
        }
        catch (Throwable e) {
            result = TestResult.failed((Throwable)e);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
        }
        this.testResult.set((Object)result);
    }

    private Object[] enrichArguments(Method method, Collection<TestEnricher> enrichers) {
        Object[] values = new Object[method.getParameterTypes().length];
        if (method.getParameterTypes().length == 0) {
            return values;
        }
        for (TestEnricher enricher : enrichers) {
            this.mergeValues(values, enricher.resolve(method));
        }
        return values;
    }

    private void mergeValues(Object[] values, Object[] resolvedValues) {
        if (resolvedValues == null || resolvedValues.length == 0) {
            return;
        }
        if (values.length != resolvedValues.length) {
            throw new IllegalStateException("TestEnricher resolved wrong argument count, expected " + values.length + " returned " + resolvedValues.length);
        }
        for (int i = 0; i < resolvedValues.length; ++i) {
            Object resvoledValue = resolvedValues[i];
            if (resvoledValue == null || values[i] != null) continue;
            values[i] = resvoledValue;
        }
    }
}

