/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.gui.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.UUID;
import org.jboss.bpm.monitor.gui.client.ChartData;
import org.jboss.bpm.monitor.model.BPAFDataSource;
import org.jboss.bpm.monitor.model.DataSourceFactory;
import org.jboss.bpm.monitor.model.json.XYDataSetJSO;
import org.jboss.bpm.monitor.model.metric.Grouping;
import org.jboss.bpm.monitor.model.metric.Timespan;
import org.jboss.errai.bus.server.annotations.Service;

@Service
public class ChartDataService
implements ChartData {
    private BPAFDataSource dataSource = DataSourceFactory.createDataSource();

    public String getDefinitionActivity(String processDefiniton, String timespanValue) {
        SortedMap grouped;
        this.assertDataSource();
        Timespan timespan = Timespan.fromValue((String)timespanValue);
        List events = this.dataSource.getDefinitionEvents(processDefiniton, timespan);
        switch (timespan.getUnit()) {
            case HOUR: {
                grouped = Grouping.byHour((List)events, (Timespan)timespan);
                break;
            }
            case DAY: {
                grouped = Grouping.byDay((List)events, (Timespan)timespan);
                break;
            }
            case WEEK: {
                grouped = Grouping.byWeek((List)events, (Timespan)timespan);
                break;
            }
            case MONTH: {
                grouped = Grouping.byMonth((List)events, (Timespan)timespan);
                break;
            }
            default: {
                throw new IllegalArgumentException("UNIT not supported: " + timespan.getUnit());
            }
        }
        XYDataSetJSO dataSet = new XYDataSetJSO("Process Instances " + timespan.getTitle(), UUID.randomUUID().toString());
        ArrayList<Long> domainData = new ArrayList<Long>(grouped.size());
        ArrayList<Long> rangeData = new ArrayList<Long>(grouped.size());
        for (Date d : grouped.keySet()) {
            domainData.add(d.getTime());
            rangeData.add(new Integer(((List)grouped.get(d)).size()).longValue());
        }
        dataSet.getDomain().add(domainData);
        dataSet.getRange().add(rangeData);
        dataSet.setAxis("date");
        return dataSet.toJSO();
    }

    private void assertDataSource() {
        if (null == this.dataSource) {
            throw new IllegalStateException("BPAFDataSource not initialized");
        }
    }
}

