/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.gui.server;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.bpm.monitor.gui.client.HistoryRecords;
import org.jboss.bpm.monitor.model.BPAFDataSource;
import org.jboss.bpm.monitor.model.DataSourceFactory;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.State;
import org.jboss.bpm.monitor.model.bpaf.Tuple;
import org.jboss.bpm.monitor.model.metric.Timespan;
import org.jboss.bpm.monitor.model.metric.TimespanFactory;
import org.jboss.errai.bus.server.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class HistoryRecordsService
implements HistoryRecords {
    private BPAFDataSource dataSource = DataSourceFactory.createDataSource();

    @Override
    public List<String> getProcessDefinitionKeys() {
        this.assertDataSource();
        return this.dataSource.getProcessDefinitions();
    }

    @Override
    public List<String> getProcessInstanceKeys(String definition) {
        this.assertDataSource();
        return this.dataSource.getProcessInstances(definition);
    }

    @Override
    public List<String> getActivityKeys(String instance) {
        this.assertDataSource();
        return this.dataSource.getActivityDefinitions(instance);
    }

    @Override
    public List<String> getAllEvents(String processInstanceId) {
        this.assertDataSource();
        List events = this.dataSource.getPastActivities(processInstanceId);
        LinkedList<String> result = new LinkedList<String>();
        for (Event event : events) {
            for (Tuple tuple : event.getDataElement()) {
                if (!"data".equals(tuple.getName())) continue;
                result.add(tuple.getValue());
            }
        }
        return result;
    }

    @Override
    public Set<String> getCompletedInstances(String definitionKey, long timestamp, String timespan) {
        return this.getInstances(definitionKey, timestamp, timespan, State.Closed_Completed);
    }

    private Set<String> getInstances(String definitionKey, long timestamp, String timespan, State completionState) {
        HashSet<String> instanceIds = new HashSet<String>();
        Timespan chartTimespan = TimespanFactory.fromValue((String)timespan);
        long[] bounds = TimespanFactory.getLeftBounds((Timespan)chartTimespan, (Date)new Date(timestamp));
        List events = this.dataSource.getInstanceEvents(definitionKey, new Timespan(bounds[0], bounds[1], chartTimespan.getUnit(), "custom"), completionState);
        for (Event e : events) {
            if (!e.getEventDetails().getCurrentState().equals((Object)completionState)) continue;
            instanceIds.add(e.getProcessInstanceID());
        }
        HashSet<String> result = new HashSet<String>();
        for (String instanceId : instanceIds) {
            List theEvents = this.dataSource.getPastActivities(instanceId);
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Instance Id: " + instanceId + " ");
            this.addCorrelationInformation(theEvents, sbuffer);
            result.add(sbuffer.toString());
        }
        return result;
    }

    private void addCorrelationInformation(List<Event> theEvents, StringBuffer sbuffer) {
        for (Event theEvent : theEvents) {
            if (!"CORRELATION_SET_WRITE".equals(theEvent.getActivityName())) continue;
            for (Tuple tuple : theEvent.getDataElement()) {
                if (!"correlation-key".equals(tuple.getName())) continue;
                sbuffer.append(" Correlation key: ");
                sbuffer.append(tuple.getValue());
            }
        }
    }

    @Override
    public Set<String> getFailedInstances(String definitionKey, long timestamp, String timespan) {
        return this.getInstances(definitionKey, timestamp, timespan, State.Closed_Completed_Failed);
    }

    @Override
    public Set<String> getTerminatedInstances(String definitionKey, long timestamp, String timespan) {
        return this.getInstances(definitionKey, timestamp, timespan, State.Closed_Cancelled_Terminated);
    }

    private void assertDataSource() {
        if (null == this.dataSource) {
            throw new IllegalStateException("BPAFDataSource not initialized");
        }
    }
}

