/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.jboss42;

import java.net.URL;
import org.jboss.bpm.api.config.Configuration;
import org.jboss.bpm.api.deployment.Deployment;
import org.jboss.bpm.api.service.DeploymentService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;

class ProcessDeploymentHelper {
    private static Logger log = Logger.getLogger(ProcessDeploymentHelper.class);
    private DeploymentService depService;

    ProcessDeploymentHelper() {
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        URL pdURL = this.getProcessDefinitionURL(di);
        log.info((Object)("Deploy ProcessDefinition: " + pdURL));
        try {
            DeploymentService depService = this.getDeploymentService();
            Deployment dep = depService.createDeployment(pdURL);
            depService.deploy(dep);
            di.context.put(Deployment.class.getName(), dep);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + pdURL, (Throwable)ex);
        }
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        URL pdURL = this.getProcessDefinitionURL(di);
        log.info((Object)("Undeploy ProcessDefinition: " + pdURL));
        Deployment dep = (Deployment)di.context.get(Deployment.class.getName());
        if (dep != null) {
            try {
                DeploymentService depService = this.getDeploymentService();
                depService.undeploy(dep);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new DeploymentException("Cannot deploy: " + pdURL, (Throwable)ex);
            }
        }
    }

    private URL getProcessDefinitionURL(DeploymentInfo di) {
        URL pdURL;
        URL uRL = pdURL = di.localUrl != null ? di.localUrl : di.url;
        if (pdURL == null) {
            throw new IllegalStateException("Cannot obtain process definition URL");
        }
        return pdURL;
    }

    private DeploymentService getDeploymentService() {
        if (this.depService == null) {
            ProcessEngine engine = Configuration.getProcessEngine();
            this.depService = (DeploymentService)engine.getService(DeploymentService.class);
        }
        return this.depService;
    }
}

