/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.history;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.Date;
import java.util.List;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.jboss.bpm.console.client.history.LoadProcessDefinitionsAction;
import org.jboss.bpm.console.client.history.LoadProcessHistoryAction;
import org.jboss.bpm.console.client.history.ProcessHistoryInstanceListView;
import org.jboss.bpm.console.client.history.ProcessSearchEvent;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHistorySearchView
implements WidgetProvider,
ViewInterface {
    public static final String ID = ProcessHistorySearchView.class.getName();
    private Controller controller = (Controller)Registry.get(Controller.class);
    private ListBox processStatusList;
    private ListBox definitionList;
    private TextBox correlationKey;
    private DateBox startTime;
    private DateBox endTime;
    private ProvisioningCallback callback;

    public ProcessHistorySearchView() {
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(LoadProcessHistoryAction.ID, (ActionInterface)new LoadProcessHistoryAction());
        this.controller.addAction(LoadProcessDefinitionsAction.ID, (ActionInterface)new LoadProcessDefinitionsAction());
    }

    public void provideWidget(ProvisioningCallback callback) {
        this.controller.handleEvent(new Event(LoadProcessDefinitionsAction.ID, null));
        this.callback = callback;
    }

    public void initialize(final List<ProcessDefinitionRef> processDefinitions) {
        LayoutPanel panel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        panel.setPadding(0);
        panel.setWidgetSpacing(5);
        ToolBar toolbar = new ToolBar();
        panel.add((Widget)toolbar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        toolbar.add((Widget)new Button("Search", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                Date edate;
                if (ProcessHistorySearchView.this.definitionList.getItemCount() < 1) {
                    return;
                }
                String proDef = ProcessHistorySearchView.this.definitionList.getValue(ProcessHistorySearchView.this.definitionList.getSelectedIndex());
                String definitionId = null;
                for (ProcessDefinitionRef ref : processDefinitions) {
                    if (!proDef.equals(ref.getName())) continue;
                    definitionId = ref.getId();
                }
                String theStatus = ProcessHistorySearchView.this.processStatusList.getValue(ProcessHistorySearchView.this.processStatusList.getSelectedIndex());
                Date theDate = ProcessHistorySearchView.this.startTime.getValue();
                if (theDate == null) {
                    theDate = new Date(103, 1, 1);
                }
                if ((edate = ProcessHistorySearchView.this.endTime.getValue()) == null) {
                    edate = new Date();
                }
                String ckey = ProcessHistorySearchView.this.correlationKey.getValue();
                ProcessSearchEvent event = new ProcessSearchEvent();
                event.setDefinitionKey(definitionId);
                event.setStatus(theStatus);
                event.setStartTime(theDate.getTime());
                event.setEndTime(edate.getTime());
                event.setKey(ckey);
                ProcessHistorySearchView.this.controller.handleEvent(new Event(LoadProcessHistoryAction.ID, (Object)event));
            }
        }));
        MosaicPanel formPanel = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        panel.add((Widget)formPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        BoxLayoutData bld1 = new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL);
        bld1.setPreferredWidth("130px");
        MosaicPanel processDefBox = new MosaicPanel((LayoutManager)new BoxLayout());
        processDefBox.add((Widget)new Label("Process Definition: "), (LayoutData)bld1);
        this.definitionList = new ListBox();
        for (ProcessDefinitionRef ref : processDefinitions) {
            this.definitionList.addItem(ref.getName());
        }
        processDefBox.add((Widget)this.definitionList);
        formPanel.add((Widget)processDefBox);
        formPanel.add((Widget)this.createProcessStatusListBox(bld1));
        formPanel.add((Widget)this.createCorrelationKeyTextBox(bld1));
        formPanel.add((Widget)this.createStartTimeDateBox(bld1));
        formPanel.add((Widget)this.createEndTimeDateBox(bld1));
        ProcessHistoryInstanceListView listview = new ProcessHistoryInstanceListView();
        final DecoratedTabLayoutPanel tabPanel = new DecoratedTabLayoutPanel(false);
        listview.provideWidget(new ProvisioningCallback(){

            public void onSuccess(Widget instance) {
                tabPanel.add(instance, "History Instances");
            }

            public void onUnavailable() {
            }
        });
        panel.add((Widget)tabPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.callback.onSuccess((Widget)panel);
    }

    private MosaicPanel createEndTimeDateBox(BoxLayoutData bld1) {
        MosaicPanel box4 = new MosaicPanel((LayoutManager)new BoxLayout());
        this.endTime = new DateBox();
        this.endTime.setWidth("550px");
        box4.add((Widget)new Label("End Time: "), (LayoutData)bld1);
        box4.add((Widget)this.endTime);
        return box4;
    }

    private MosaicPanel createStartTimeDateBox(BoxLayoutData bld1) {
        MosaicPanel box3 = new MosaicPanel((LayoutManager)new BoxLayout());
        this.startTime = new DateBox();
        this.startTime.setWidth("550px");
        box3.add((Widget)new Label("Start Time: "), (LayoutData)bld1);
        box3.add((Widget)this.startTime);
        return box3;
    }

    private MosaicPanel createCorrelationKeyTextBox(BoxLayoutData bld1) {
        MosaicPanel box2 = new MosaicPanel((LayoutManager)new BoxLayout());
        this.correlationKey = new TextBox();
        this.correlationKey.setWidth("550px");
        box2.add((Widget)new Label("Correlation Key: "), (LayoutData)bld1);
        box2.add((Widget)this.correlationKey);
        box2.add((Widget)new Label(" format: correlation name = [correlation value], e.g Session=[1]"));
        return box2;
    }

    private MosaicPanel createProcessStatusListBox(BoxLayoutData bld1) {
        MosaicPanel box1 = new MosaicPanel((LayoutManager)new BoxLayout());
        this.processStatusList = new ListBox();
        this.processStatusList.addItem("COMPLETED");
        this.processStatusList.addItem("FAILED");
        this.processStatusList.addItem("TERMINATED");
        box1.add((Widget)new Label("Process Status: "), (LayoutData)bld1);
        box1.add((Widget)this.processStatusList);
        return box1;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }
}

