/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.event.RowSelectionEvent;
import org.gwt.mosaic.ui.client.event.RowSelectionHandler;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.gwt.mosaic.ui.client.table.AbstractScrollTable;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.ModelCommands;
import org.jboss.bpm.console.client.common.ModelParts;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.LoadHistoryDiagramAction;
import org.jboss.bpm.console.client.process.UpdateHistoryDefinitionAction;
import org.jboss.bpm.console.client.process.UpdateHistoryDefinitionsAction;
import org.jboss.bpm.console.client.process.UpdateHistoryInstanceAction;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.Message;
import org.jboss.errai.bus.client.api.MessageCallback;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionHistoryListView
implements WidgetProvider,
ViewInterface,
DataDriven {
    public static final String ID = DefinitionHistoryListView.class.getName();
    private Controller controller;
    private MosaicPanel definitionList = null;
    private ListBox<ProcessDefinitionRef> listBox;
    private boolean isInitialized;
    private List<ProcessDefinitionRef> definitions = null;
    private PagingPanel pagingPanel;
    private MosaicPanel panel;

    public void provideWidget(ProvisioningCallback callback) {
        this.panel = new MosaicPanel();
        this.panel.setWidgetSpacing(0);
        this.panel.setPadding(0);
        this.listBox = this.createListBox();
        final Controller controller = (Controller)Registry.get(Controller.class);
        controller.addView(ID, (ViewInterface)this);
        controller.addAction(UpdateHistoryDefinitionAction.ID, (ActionInterface)new UpdateHistoryDefinitionAction());
        controller.addAction(UpdateHistoryInstanceAction.ID, (ActionInterface)new UpdateHistoryInstanceAction());
        controller.addAction(LoadHistoryDiagramAction.ID, (ActionInterface)new LoadHistoryDiagramAction());
        controller.addAction(UpdateHistoryDefinitionsAction.ID, (ActionInterface)new UpdateHistoryDefinitionsAction());
        this.initialize();
        Timer t = new Timer(){

            public void run() {
                controller.handleEvent(new Event(UpdateHistoryDefinitionsAction.ID, null));
            }
        };
        t.schedule(500);
        callback.onSuccess((Widget)this.panel);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.definitionList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.definitionList.setPadding(0);
            this.definitionList.setWidgetSpacing(0);
            MosaicPanel toolBox = new MosaicPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(0);
            toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
            ToolBar toolBar = new ToolBar();
            ClickHandler clickHandler = new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    DefinitionHistoryListView.this.reload();
                }
            };
            toolBar.add((Widget)new Button("Refresh", clickHandler));
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.definitionList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.definitionList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.pagingPanel = new PagingPanel(new PagingCallback(){

                public void rev() {
                    DefinitionHistoryListView.this.renderFiltered();
                }

                public void ffw() {
                    DefinitionHistoryListView.this.renderFiltered();
                }
            });
            this.definitionList.add((Widget)this.pagingPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.panel.add((Widget)this.definitionList);
            ErraiBus.get().subscribe("appContext.model.listener", new MessageCallback(){

                public void callback(Message message) {
                    switch (ModelCommands.valueOf(message.getCommandType())) {
                        case HAS_BEEN_UPDATED: {
                            if (!((String)message.get(String.class, (Enum)ModelParts.CLASS)).equals("deploymentModel")) break;
                            DefinitionHistoryListView.this.reload();
                        }
                    }
                }
            });
            this.isInitialized = true;
        }
    }

    private void reload() {
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                DefaultListModel model = (DefaultListModel)DefinitionHistoryListView.this.listBox.getModel();
                model.clear();
                DefinitionHistoryListView.this.controller.handleEvent(new Event(UpdateHistoryDefinitionsAction.ID, null));
            }
        });
    }

    private ListBox<ProcessDefinitionRef> createListBox() {
        final ListBox listBox = new ListBox(new String[]{"<b>Process</b>", "v."});
        listBox.setFocus(true);
        listBox.setCellRenderer((ListBox.CellRenderer)new ListBox.CellRenderer<ProcessDefinitionRef>(){

            public void renderCell(ListBox<ProcessDefinitionRef> listBox, int row, int column, ProcessDefinitionRef item) {
                switch (column) {
                    case 0: {
                        String name = item.getName();
                        String s = name.indexOf("}") > 0 ? name.substring(name.lastIndexOf("}") + 1, name.length()) : name;
                        String color = item.isSuspended() ? "#CCCCCC" : "#000000";
                        String text = "<div style=\"color:" + color + "\">" + s + "</div>";
                        listBox.setWidget(row, column, (Widget)new HTML(text));
                        break;
                    }
                    case 1: {
                        listBox.setText(row, column, String.valueOf(item.getVersion()));
                        break;
                    }
                    case 2: {
                        listBox.setText(row, column, String.valueOf(item.isSuspended()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected column size");
                    }
                }
            }
        });
        listBox.setMinimumColumnWidth(0, 190);
        listBox.setColumnResizePolicy(AbstractScrollTable.ColumnResizePolicy.MULTI_CELL);
        listBox.addRowSelectionHandler(new RowSelectionHandler(){

            public void onRowSelection(RowSelectionEvent rowSelectionEvent) {
                int index = listBox.getSelectedIndex();
                if (index != -1) {
                    ProcessDefinitionRef item = (ProcessDefinitionRef)listBox.getItem(index);
                    DefinitionHistoryListView.this.controller.handleEvent(new Event(UpdateHistoryDefinitionAction.ID, (Object)item));
                }
            }
        });
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void reset() {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
    }

    @Override
    public void update(Object ... data) {
        this.definitions = (List)data[0];
        this.pagingPanel.reset();
        this.renderFiltered();
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.panel, isLoading);
    }

    private void renderFiltered() {
        if (this.definitions != null) {
            this.reset();
            DefaultListModel model = (DefaultListModel)this.listBox.getModel();
            ArrayList<ProcessDefinitionRef> tmp = new ArrayList<ProcessDefinitionRef>();
            for (ProcessDefinitionRef def : this.definitions) {
                tmp.add(def);
            }
            for (ProcessDefinitionRef def : this.pagingPanel.trim(tmp)) {
                model.add((Object)def);
            }
            if (this.listBox.getSelectedIndex() != -1) {
                this.listBox.setItemSelected(this.listBox.getSelectedIndex(), false);
            }
        }
    }

    public ProcessDefinitionRef getSelection() {
        ProcessDefinitionRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = (ProcessDefinitionRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }
}

