/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.gwt.mosaic.core.client.Dimension;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.MessageBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.event.RowSelectionEvent;
import org.gwt.mosaic.ui.client.event.RowSelectionHandler;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.IFrameWindowCallback;
import org.jboss.bpm.console.client.common.IFrameWindowPanel;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TokenReference;
import org.jboss.bpm.console.client.process.ClearInstancesAction;
import org.jboss.bpm.console.client.process.DeleteInstanceAction;
import org.jboss.bpm.console.client.process.InstanceDetailView;
import org.jboss.bpm.console.client.process.SignalExecutionAction;
import org.jboss.bpm.console.client.process.StartNewInstanceAction;
import org.jboss.bpm.console.client.process.StateChangeAction;
import org.jboss.bpm.console.client.process.UpdateInstanceDetailAction;
import org.jboss.bpm.console.client.process.UpdateInstancesAction;
import org.jboss.bpm.console.client.process.events.InstanceEvent;
import org.jboss.bpm.console.client.process.events.SignalInstanceEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceListView
implements WidgetProvider,
ViewInterface,
DataDriven {
    public static final String ID = InstanceListView.class.getName();
    private Controller controller;
    private MosaicPanel instanceList = null;
    private ListBox<ProcessInstanceRef> listBox;
    private ProcessDefinitionRef currentDefinition;
    private boolean isInitialized;
    private List<ProcessInstanceRef> cachedInstances = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ApplicationContext appContext;
    private IFrameWindowPanel iframeWindow = null;
    private boolean isRiftsawInstance;
    MosaicPanel panel;
    private Button startBtn;
    private Button terminateBtn;
    private Button deleteBtn;
    private Button signalBtn;
    private Button refreshBtn;
    private List<TokenReference> tokensToSignal = null;
    private WidgetWindowPanel signalWindowPanel;
    private ListBox<TokenReference> listBoxTokens = null;
    private List<TextBox> signalTextBoxes = null;
    private TextBox eventData = null;
    private ImageResource greenIcon;
    private TextBox signalRef = null;

    public void provideWidget(ProvisioningCallback callback) {
        this.appContext = (ApplicationContext)Registry.get(ApplicationContext.class);
        this.isRiftsawInstance = this.appContext.getConfig().getProfileName().equals("BPEL Console");
        this.panel = new MosaicPanel();
        this.panel.setPadding(0);
        ((Controller)Registry.get(Controller.class)).addView(ID, (ViewInterface)this);
        this.initialize();
        ConsoleIconBundle imageBundle = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.greenIcon = imageBundle.greenIcon();
        callback.onSuccess((Widget)this.panel);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.instanceList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.instanceList.setPadding(0);
            this.instanceList.setWidgetSpacing(0);
            this.listBox = new ListBox(new String[]{"<b>Instance</b>", "State", "Start Date"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new ListBox.CellRenderer<ProcessInstanceRef>(){

                public void renderCell(ListBox<ProcessInstanceRef> listBox, int row, int column, ProcessInstanceRef item) {
                    switch (column) {
                        case 0: {
                            listBox.setText(row, column, item.getId());
                            break;
                        }
                        case 1: {
                            listBox.setText(row, column, item.getState().toString());
                            break;
                        }
                        case 2: {
                            String d = item.getStartDate() != null ? InstanceListView.this.dateFormat.format(item.getStartDate()) : "";
                            listBox.setText(row, column, d);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected column size");
                        }
                    }
                }
            });
            this.listBox.addRowSelectionHandler(new RowSelectionHandler(){

                public void onRowSelection(RowSelectionEvent rowSelectionEvent) {
                    int index = InstanceListView.this.listBox.getSelectedIndex();
                    if (index != -1) {
                        ProcessInstanceRef item = (ProcessInstanceRef)InstanceListView.this.listBox.getItem(index);
                        if (InstanceListView.this.isSignalable(item)) {
                            InstanceListView.this.signalBtn.setEnabled(true);
                        } else {
                            InstanceListView.this.signalBtn.setEnabled(false);
                        }
                        InstanceListView.this.terminateBtn.setEnabled(true);
                        InstanceListView.this.controller.handleEvent(new Event(UpdateInstanceDetailAction.ID, (Object)new InstanceEvent(InstanceListView.this.currentDefinition, item)));
                    }
                }
            });
            MosaicPanel toolBox = new MosaicPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            ToolBar toolBar = new ToolBar();
            this.refreshBtn = new Button("Refresh", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    InstanceListView.this.controller.handleEvent(new Event(UpdateInstancesAction.ID, (Object)InstanceListView.this.getCurrentDefinition()));
                }
            });
            toolBar.add((Widget)this.refreshBtn);
            this.refreshBtn.setEnabled(false);
            toolBar.addSeparator();
            this.startBtn = new Button("Start", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    MessageBox.confirm((String)"Start new execution", (String)"Do you want to start a new execution of this process?", (MessageBox.ConfirmationCallback)new MessageBox.ConfirmationCallback(){

                        public void onResult(boolean doIt) {
                            if (doIt) {
                                boolean hasForm;
                                String url = InstanceListView.this.getCurrentDefinition().getFormUrl();
                                boolean bl = hasForm = url != null && !url.equals("");
                                if (hasForm) {
                                    ProcessDefinitionRef definition = InstanceListView.this.getCurrentDefinition();
                                    InstanceListView.this.iframeWindow = new IFrameWindowPanel(definition.getFormUrl(), "New Process Instance: " + definition.getId());
                                    InstanceListView.this.iframeWindow.setCallback(new IFrameWindowCallback(){

                                        public void onWindowClosed() {
                                            InstanceListView.this.controller.handleEvent(new Event(UpdateInstancesAction.ID, (Object)InstanceListView.this.getCurrentDefinition()));
                                        }
                                    });
                                    InstanceListView.this.iframeWindow.show();
                                } else {
                                    InstanceListView.this.controller.handleEvent(new Event(StartNewInstanceAction.ID, (Object)InstanceListView.this.getCurrentDefinition()));
                                }
                            }
                        }
                    });
                }
            });
            this.terminateBtn = new Button("Terminate", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    if (InstanceListView.this.getSelection() != null) {
                        MessageBox.confirm((String)"Terminate instance", (String)"Terminating this instance will stop further execution.", (MessageBox.ConfirmationCallback)new MessageBox.ConfirmationCallback(){

                            public void onResult(boolean doIt) {
                                if (doIt) {
                                    ProcessInstanceRef selection = InstanceListView.this.getSelection();
                                    selection.setState(ProcessInstanceRef.STATE.ENDED);
                                    selection.setEndResult(ProcessInstanceRef.RESULT.OBSOLETE);
                                    InstanceListView.this.controller.handleEvent(new Event(StateChangeAction.ID, (Object)selection));
                                }
                            }
                        });
                    } else {
                        MessageBox.alert((String)"Missing selection", (String)"Please select an instance");
                    }
                }
            });
            this.deleteBtn = new Button("Delete", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    if (InstanceListView.this.getSelection() != null) {
                        MessageBox.confirm((String)"Delete instance", (String)"Deleting this instance will remove any history information and associated tasks as well.", (MessageBox.ConfirmationCallback)new MessageBox.ConfirmationCallback(){

                            public void onResult(boolean doIt) {
                                if (doIt) {
                                    ProcessInstanceRef selection = InstanceListView.this.getSelection();
                                    selection.setState(ProcessInstanceRef.STATE.ENDED);
                                    InstanceListView.this.controller.handleEvent(new Event(DeleteInstanceAction.ID, (Object)selection));
                                }
                            }
                        });
                    } else {
                        MessageBox.alert((String)"Missing selection", (String)"Please select an instance");
                    }
                }
            });
            this.signalBtn = new Button("Signal", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    if (InstanceListView.this.getSelection() != null) {
                        InstanceListView.this.createSignalWindow();
                    } else {
                        MessageBox.alert((String)"Missing selection", (String)"Please select an instance");
                    }
                }
            });
            if (!this.isRiftsawInstance) {
                toolBar.add((Widget)this.startBtn);
                toolBar.add((Widget)this.signalBtn);
                toolBar.add((Widget)this.deleteBtn);
                this.startBtn.setEnabled(false);
                this.deleteBtn.setEnabled(false);
                this.signalBtn.setEnabled(false);
            }
            toolBar.add((Widget)this.terminateBtn);
            this.terminateBtn.setEnabled(false);
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            if (this.cachedInstances != null) {
                this.bindData(this.cachedInstances);
            }
            MosaicPanel layout = new MosaicPanel((LayoutManager)new BorderLayout());
            layout.setPadding(0);
            layout.add((Widget)this.instanceList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            InstanceDetailView detailsView = new InstanceDetailView();
            this.controller.addView(InstanceDetailView.ID, (ViewInterface)detailsView);
            this.controller.addAction(UpdateInstanceDetailAction.ID, (ActionInterface)new UpdateInstanceDetailAction());
            this.controller.addAction(ClearInstancesAction.ID, (ActionInterface)new ClearInstancesAction());
            this.controller.addAction(SignalExecutionAction.ID, (ActionInterface)new SignalExecutionAction());
            layout.add((Widget)detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.panel.add((Widget)layout);
            this.isInitialized = true;
        }
    }

    public ProcessInstanceRef getSelection() {
        ProcessInstanceRef selection = null;
        if (this.listBox.getSelectedIndex() != -1) {
            selection = (ProcessInstanceRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public ProcessDefinitionRef getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void reset() {
        this.currentDefinition = null;
        this.cachedInstances = new ArrayList<ProcessInstanceRef>();
        this.renderUpdate();
        this.startBtn.setEnabled(false);
        this.terminateBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.signalBtn.setEnabled(false);
        this.refreshBtn.setEnabled(false);
    }

    @Override
    public void update(Object ... data) {
        this.currentDefinition = (ProcessDefinitionRef)data[0];
        this.cachedInstances = (List)data[1];
        this.renderUpdate();
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.instanceList, isLoading);
    }

    private void renderUpdate() {
        if (this.isInitialized()) {
            this.bindData(this.cachedInstances);
            this.controller.handleEvent(new Event(UpdateInstanceDetailAction.ID, (Object)new InstanceEvent(this.currentDefinition, null)));
            this.startBtn.setEnabled(true);
            this.deleteBtn.setEnabled(true);
            this.refreshBtn.setEnabled(true);
            this.signalBtn.setEnabled(false);
        }
    }

    private void bindData(List<ProcessInstanceRef> instances) {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        List<ProcessInstanceRef> list = instances;
        for (ProcessInstanceRef inst : list) {
            model.add((Object)inst);
        }
        this.panel.invalidate();
    }

    private boolean isSignalable(ProcessInstanceRef processInstance) {
        this.tokensToSignal = new ArrayList<TokenReference>();
        if (processInstance.getRootToken() != null && processInstance.getRootToken().canBeSignaled()) {
            this.tokensToSignal.add(processInstance.getRootToken());
        } else if (processInstance.getRootToken() != null && processInstance.getRootToken().getChildren() != null) {
            this.collectSignalableTokens(processInstance.getRootToken(), this.tokensToSignal);
        }
        return this.tokensToSignal.size() > 0;
    }

    private void collectSignalableTokens(TokenReference tokenParent, List<TokenReference> tokensToSignal) {
        if (tokenParent.getChildren() != null) {
            for (TokenReference token : tokenParent.getChildren()) {
                if (token.canBeSignaled()) {
                    tokensToSignal.add(token);
                }
                this.collectSignalableTokens(token, tokensToSignal);
            }
        }
    }

    private void createSignalWindow() {
        this.signalTextBoxes = new ArrayList<TextBox>();
        MosaicPanel layout = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        layout.setStyleName("bpm-window-layout");
        layout.setPadding(5);
        MosaicPanel toolBox = new MosaicPanel();
        toolBox.setPadding(0);
        toolBox.setWidgetSpacing(5);
        toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        ToolBar toolBar = new ToolBar();
        toolBar.add((Widget)new Button("Signal", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                int selectedToken = InstanceListView.this.listBoxTokens.getSelectedIndex();
                if (selectedToken != -1 && InstanceListView.this.signalRef.getText().length() > 0) {
                    MessageBox.alert((String)"Multi selection", (String)"Known active nodes and signal ref (text box) is given, please choose only one of them");
                } else if (selectedToken != -1) {
                    InstanceListView.this.controller.handleEvent(new Event(SignalExecutionAction.ID, (Object)new SignalInstanceEvent(InstanceListView.this.getCurrentDefinition(), InstanceListView.this.getSelection(), (TokenReference)InstanceListView.this.listBoxTokens.getItem(selectedToken), InstanceListView.this.eventData.getText(), selectedToken)));
                } else if (InstanceListView.this.signalRef.getText().length() > 0) {
                    TokenReference token = new TokenReference();
                    token.setId(InstanceListView.this.getSelection().getId());
                    token.setName(InstanceListView.this.signalRef.getText());
                    int foundMatch = -1;
                    int index = 0;
                    for (TokenReference ref : InstanceListView.this.tokensToSignal) {
                        if (ref.getName().equals(token.getName())) {
                            foundMatch = index;
                            break;
                        }
                        ++index;
                    }
                    InstanceListView.this.controller.handleEvent(new Event(SignalExecutionAction.ID, (Object)new SignalInstanceEvent(InstanceListView.this.getCurrentDefinition(), InstanceListView.this.getSelection(), token, InstanceListView.this.eventData.getText(), foundMatch)));
                } else {
                    MessageBox.alert((String)"Incomplete selection", (String)"Please select element you want to signal");
                }
            }
        }));
        toolBar.add((Widget)new Button("Close", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                InstanceListView.this.signalWindowPanel.close();
                InstanceListView.this.controller.handleEvent(new Event(UpdateInstancesAction.ID, (Object)InstanceListView.this.getCurrentDefinition()));
            }
        }));
        toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        layout.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        Label header = new Label("Known active nodes to signal: ");
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.listBoxTokens = new ListBox(new String[]{"Node name", "Signal ref"});
        this.listBoxTokens.setCellRenderer((ListBox.CellRenderer)new ListBox.CellRenderer<TokenReference>(){

            public void renderCell(ListBox<TokenReference> listBox, int row, int column, TokenReference item) {
                switch (column) {
                    case 0: {
                        listBox.setText(row, column, item.getCurrentNodeName());
                        break;
                    }
                    case 1: {
                        listBox.setText(row, column, item.getName());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected column size");
                    }
                }
            }
        });
        this.renderSignalListBox(-1);
        layout.add((Widget)this.listBoxTokens, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        Label headerSignalRef = new Label("Signal ref");
        headerSignalRef.setStyleName("bpm-label-header");
        layout.add((Widget)headerSignalRef, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.signalRef = new TextBox();
        this.signalRef.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (InstanceListView.this.listBox.getSelectedIndex() != -1) {
                    InstanceListView.this.listBoxTokens.setItemSelected(InstanceListView.this.listBox.getSelectedIndex(), false);
                }
            }
        });
        layout.add((Widget)this.signalRef, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        Label headerSignals = new Label("Event data");
        headerSignals.setStyleName("bpm-label-header");
        layout.add((Widget)headerSignals, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.eventData = new TextBox();
        layout.add((Widget)this.eventData, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.signalWindowPanel = new WidgetWindowPanel("Signal process", (Widget)layout, false);
        this.signalWindowPanel.setSize(new Dimension(500, 400));
    }

    public void renderSignalListBox(int i) {
        if (i > -1) {
            this.tokensToSignal.remove(i);
        }
        ((DefaultListModel)this.listBoxTokens.getModel()).clear();
        if (!this.tokensToSignal.isEmpty()) {
            for (TokenReference token : this.tokensToSignal) {
                ((DefaultListModel)this.listBoxTokens.getModel()).add((Object)token);
            }
        }
        if (this.signalRef != null) {
            this.signalRef.setText("");
        }
        if (this.eventData != null) {
            this.eventData.setText("");
        }
    }
}

