/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.MessageBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.event.RowSelectionEvent;
import org.gwt.mosaic.ui.client.event.RowSelectionHandler;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.ModelCommands;
import org.jboss.bpm.console.client.common.ModelParts;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.AbstractTaskList;
import org.jboss.bpm.console.client.task.AssignTaskAction;
import org.jboss.bpm.console.client.task.ClaimTaskAction;
import org.jboss.bpm.console.client.task.LoadTasksAction;
import org.jboss.bpm.console.client.task.LoadTasksParticipationAction;
import org.jboss.bpm.console.client.task.ReleaseTaskAction;
import org.jboss.bpm.console.client.task.ReloadAllTaskListsAction;
import org.jboss.bpm.console.client.task.SkipTaskAction;
import org.jboss.bpm.console.client.task.TaskDetailView;
import org.jboss.bpm.console.client.task.UpdateDetailsAction;
import org.jboss.bpm.console.client.task.events.DetailViewEvent;
import org.jboss.bpm.console.client.task.events.TaskIdentityEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.Message;
import org.jboss.errai.bus.client.api.MessageCallback;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

public class OpenTasksView
extends AbstractTaskList
implements WidgetProvider,
DataDriven {
    public static final String ID = OpenTasksView.class.getName();
    private TaskDetailView detailsView;
    private ApplicationContext appContext;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private PagingPanel pagingPanel;
    private MosaicPanel panel;
    private Controller controller;
    private Button skipBtn;
    private static boolean actionSetup = false;

    public static void registerCommonActions(Controller controller) {
        if (!actionSetup) {
            controller.addAction(LoadTasksAction.ID, (ActionInterface)new LoadTasksAction());
            controller.addAction(LoadTasksParticipationAction.ID, (ActionInterface)new LoadTasksParticipationAction());
            controller.addAction(ClaimTaskAction.ID, (ActionInterface)new ClaimTaskAction());
            controller.addAction(ReleaseTaskAction.ID, (ActionInterface)new ReleaseTaskAction());
            controller.addAction(UpdateDetailsAction.ID, (ActionInterface)new UpdateDetailsAction());
            controller.addAction(AssignTaskAction.ID, (ActionInterface)new AssignTaskAction());
            controller.addAction(ReloadAllTaskListsAction.ID, (ActionInterface)new ReloadAllTaskListsAction());
            controller.addAction(SkipTaskAction.ID, (ActionInterface)new SkipTaskAction());
            actionSetup = true;
        }
    }

    public void provideWidget(ProvisioningCallback callback) {
        this.panel = new MosaicPanel((LayoutManager)new BorderLayout());
        this.controller = (Controller)Registry.get(Controller.class);
        this.appContext = (ApplicationContext)Registry.get(ApplicationContext.class);
        this.initialize();
        OpenTasksView.registerCommonActions(this.controller);
        this.controller.addView(ID, (ViewInterface)this);
        this.panel.add((Widget)this.taskList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
        this.panel.add((Widget)this.detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
        callback.onSuccess((Widget)this.panel);
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.taskList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.taskList.setPadding(0);
            this.taskList.setWidgetSpacing(0);
            this.listBox = new ListBox(new String[]{"Priority", "Process", "Task Name", "Status", "Due Date"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new ListBox.CellRenderer<TaskRef>(){

                public void renderCell(ListBox<TaskRef> listBox, int row, int column, TaskRef item) {
                    switch (column) {
                        case 0: {
                            listBox.setText(row, column, String.valueOf(item.getPriority()));
                            break;
                        }
                        case 1: {
                            listBox.setText(row, column, item.getProcessId());
                            break;
                        }
                        case 2: {
                            listBox.setText(row, column, item.getName());
                            break;
                        }
                        case 3: {
                            listBox.setText(row, column, String.valueOf(item.getCurrentState()));
                            break;
                        }
                        case 4: {
                            String d = item.getDueDate() != null ? OpenTasksView.this.dateFormat.format(item.getDueDate()) : "";
                            listBox.setText(row, column, d);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected column size");
                        }
                    }
                }
            });
            this.listBox.addRowSelectionHandler(new RowSelectionHandler(){

                public void onRowSelection(RowSelectionEvent rowSelectionEvent) {
                    TaskRef task = OpenTasksView.this.getSelection();
                    if (task != null) {
                        if (!task.isBlocking()) {
                            OpenTasksView.this.skipBtn.setEnabled(true);
                        } else {
                            OpenTasksView.this.skipBtn.setEnabled(false);
                        }
                        OpenTasksView.this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("OpenDetailView", task)));
                    }
                }
            });
            MosaicPanel toolBox = new MosaicPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new Button("Refresh", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    OpenTasksView.this.reload();
                }
            }));
            toolBar.add((Widget)new Button("Claim", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    TaskRef selection = OpenTasksView.this.getSelection();
                    if (selection != null) {
                        OpenTasksView.this.controller.handleEvent(new Event(ClaimTaskAction.ID, (Object)new TaskIdentityEvent(OpenTasksView.this.appContext.getAuthentication().getUsername(), selection)));
                    } else {
                        MessageBox.alert((String)"Missing selection", (String)"Please select a task");
                    }
                }
            }));
            this.skipBtn = new Button("Skip", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    TaskRef selection = OpenTasksView.this.getSelection();
                    if (selection != null && !selection.isBlocking()) {
                        OpenTasksView.this.controller.handleEvent(new Event(SkipTaskAction.ID, (Object)new TaskIdentityEvent(OpenTasksView.this.appContext.getAuthentication().getUsername(), selection)));
                    } else {
                        MessageBox.alert((String)"Missing selection", (String)"Please select a task");
                    }
                }
            });
            this.skipBtn.setEnabled(false);
            toolBar.add((Widget)this.skipBtn);
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.taskList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.taskList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.pagingPanel = new PagingPanel(new PagingCallback(){

                public void rev() {
                    OpenTasksView.this.renderUpdate();
                }

                public void ffw() {
                    OpenTasksView.this.renderUpdate();
                }
            });
            this.taskList.add((Widget)this.pagingPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.detailsView = new TaskDetailView(true);
            this.controller.addView("OpenDetailView", (ViewInterface)this.detailsView);
            this.detailsView.initialize();
            ErraiBus.get().subscribe("appContext.model.listener", new MessageCallback(){

                public void callback(Message message) {
                    switch (ModelCommands.valueOf(message.getCommandType())) {
                        case HAS_BEEN_UPDATED: {
                            if (!((String)message.get(String.class, (Enum)ModelParts.CLASS)).equals("processModel")) break;
                            OpenTasksView.this.reload();
                        }
                    }
                }
            });
            Timer t = new Timer(){

                public void run() {
                    OpenTasksView.this.reload();
                }
            };
            t.schedule(500);
            this.isInitialized = true;
        }
    }

    private void reload() {
        this.controller.handleEvent(new Event(LoadTasksParticipationAction.ID, (Object)this.getAssignedIdentity()));
    }

    public void reset() {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("OpenDetailView", null)));
    }

    public void update(Object ... data) {
        this.identity = (String)data[0];
        this.cachedTasks = (List)data[1];
        this.pagingPanel.reset();
        this.renderUpdate();
    }

    public void setLoading(boolean isLoading) {
        if (this.panel.isVisible()) {
            LoadingOverlay.on((Widget)this.taskList, isLoading);
        }
    }

    private void renderUpdate() {
        this.initialize();
        this.reset();
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        List trimmed = this.pagingPanel.trim(this.cachedTasks);
        for (TaskRef task : trimmed) {
            if (TaskRef.STATE.OPEN != task.getCurrentState()) continue;
            model.add((Object)task);
        }
    }
}

