/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.ui.client.MessageBox;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Authentication;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.bus.client.api.builder.MessageBuildSendableWithReply;
import org.jboss.errai.bus.client.protocols.SecurityParts;
import org.jboss.errai.bus.client.security.SecurityService;
import org.jboss.errai.workspaces.client.framework.Registry;

public class LoginView
implements ViewInterface {
    public static final String NAME = "loginView";
    private ConsoleConfig config;
    private Authentication auth;
    private WindowPanel window = null;
    private TextBox usernameInput;
    private PasswordTextBox passwordInput;
    public static final String[] KNOWN_ROLES = new String[]{"admin", "manager", "user"};
    private HTML messagePanel = new HTML("Authentication required");

    public LoginView() {
        this.config = ((ApplicationContext)Registry.get(ApplicationContext.class)).getConfig();
    }

    public void setController(Controller controller) {
    }

    public void display() {
        Authentication.logout(this.config);
        this.requestSessionID();
    }

    private void requestSessionID() {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, this.config.getConsoleServerUrl() + "/rs/identity/sid");
        try {
            rb.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    ConsoleLog.debug("SID: " + response.getText());
                    ConsoleLog.debug("Cookies: " + Cookies.getCookieNames());
                    String sid = response.getText();
                    LoginView.this.auth = new Authentication(LoginView.this.config, sid, URLBuilder.getInstance().getUserInRoleURL(KNOWN_ROLES));
                    LoginView.this.auth.setCallback(new Authentication.AuthCallback(){

                        public void onLoginSuccess(Request request, Response response) {
                            LoginView.this.usernameInput.setText("");
                            LoginView.this.passwordInput.setText("");
                            LoginView.this.window.hide();
                            DeferredCommand.addCommand((Command)new Command(){

                                public void execute() {
                                    DOM.getElementById((String)"splash").getStyle().setProperty("zIndex", "1000");
                                    DOM.getElementById((String)"ui_loading").getStyle().setProperty("visibility", "visible");
                                    GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

                                        public void onFailure(Throwable throwable) {
                                            GWT.log((String)"Code splitting failed", (Throwable)throwable);
                                            MessageBox.error((String)"Code splitting failed", (String)throwable.getMessage());
                                        }

                                        public void onSuccess() {
                                            List<String> roles = LoginView.this.auth.getRolesAssigned();
                                            StringBuilder roleString = new StringBuilder();
                                            int index = 1;
                                            for (String s : roles) {
                                                roleString.append(s);
                                                if (index < roles.size()) {
                                                    roleString.append(",");
                                                }
                                                ++index;
                                            }
                                            ((SecurityService)Registry.get(SecurityService.class)).setDeferredNotification(false);
                                            ((MessageBuildSendableWithReply)MessageBuilder.createMessage().toSubject("AuthorizationListener").signalling().with((Enum)SecurityParts.Name, (Object)LoginView.this.auth.getUsername()).with((Enum)SecurityParts.Roles, (Object)roleString.toString()).noErrorHandling()).sendNowWith(ErraiBus.get());
                                            Timer t = new Timer(){

                                                public void run() {
                                                    DeferredCommand.addCommand((Command)new Command(){

                                                        public void execute() {
                                                            DOM.getElementById((String)"ui_loading").getStyle().setProperty("visibility", "hidden");
                                                            DOM.getElementById((String)"splash").getStyle().setProperty("visibility", "hidden");
                                                        }
                                                    });
                                                }
                                            };
                                            t.schedule(2000);
                                        }
                                    });
                                }
                            });
                            LoginView.this.window = null;
                        }

                        public void onLoginFailed(Request request, Throwable t) {
                            LoginView.this.usernameInput.setText("");
                            LoginView.this.passwordInput.setText("");
                            LoginView.this.messagePanel.setHTML("<div style='color:#CC0000;'>" + t.getMessage() + "</div>");
                        }
                    });
                    Registry.set(Authentication.class, (Object)LoginView.this.auth);
                    LoginView.this.createLayoutWindowPanel();
                    LoginView.this.window.pack();
                    LoginView.this.window.center();
                    LoginView.this.usernameInput.setFocus(true);
                }

                public void onError(Request request, Throwable t) {
                    ConsoleLog.error("Failed to initiate session", t);
                }
            });
        }
        catch (RequestException e) {
            ConsoleLog.error("Request error", e);
        }
    }

    private void createLayoutWindowPanel() {
        this.window = new WindowPanel(this.config.getProfileName(), false);
        Widget closeBtn = this.window.getHeader().getWidget(0, Caption.CaptionRegion.RIGHT);
        closeBtn.setVisible(false);
        this.window.setAnimationEnabled(false);
        MosaicPanel panel = new MosaicPanel();
        panel.addStyleName("bpm-login");
        this.createLayoutContent(panel);
        this.window.setWidget((Widget)panel);
    }

    private void createLayoutContent(MosaicPanel layoutPanel) {
        layoutPanel.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        layoutPanel.setPadding(10);
        Widget form = this.createForm();
        Button submit = new Button("Login");
        submit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                LoginView.this.engageLogin();
            }
        });
        HTML html = new HTML("Version: 2.3.6.Final");
        html.setStyleName("bpm-login-info");
        MosaicPanel btnPanel = new MosaicPanel((LayoutManager)new BoxLayout());
        btnPanel.add((Widget)html, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        btnPanel.add((Widget)submit);
        layoutPanel.add((Widget)this.messagePanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        layoutPanel.add(form, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        layoutPanel.add((Widget)btnPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
    }

    private Widget createForm() {
        MosaicPanel panel = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        panel.setPadding(0);
        MosaicPanel box1 = new MosaicPanel((LayoutManager)new BoxLayout());
        box1.setPadding(0);
        MosaicPanel box2 = new MosaicPanel((LayoutManager)new BoxLayout());
        box2.setPadding(0);
        this.usernameInput = new TextBox();
        this.passwordInput = new PasswordTextBox();
        BoxLayoutData bld1 = new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL);
        bld1.setPreferredWidth("70px");
        box1.add((Widget)new Label("Username:"), (LayoutData)bld1);
        box1.add((Widget)this.usernameInput);
        box2.add((Widget)new Label("Password:"), (LayoutData)bld1);
        box2.add((Widget)this.passwordInput);
        this.passwordInput.addKeyboardListener(new KeyboardListener(){

            public void onKeyDown(Widget widget, char c, int i) {
            }

            public void onKeyPress(Widget widget, char c, int i) {
            }

            public void onKeyUp(Widget widget, char c, int i) {
                if (c == '\r') {
                    LoginView.this.engageLogin();
                }
            }
        });
        panel.add((Widget)box1);
        panel.add((Widget)box2);
        return panel;
    }

    private void engageLogin() {
        this.requestProtectedResource();
    }

    private void requestProtectedResource() {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, this.config.getConsoleServerUrl() + "/rs/identity/secure/sid");
        try {
            rb.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    ConsoleLog.debug("requestProtectedResource() HTTP " + response.getStatusCode());
                    LoginView.this.auth.login(LoginView.this.getUsername(), LoginView.this.getPassword());
                }

                public void onError(Request request, Throwable t) {
                    ConsoleLog.error("Failed to request protected resource", t);
                }
            });
        }
        catch (RequestException e) {
            ConsoleLog.error("Request error", e);
        }
    }

    private String getUsername() {
        return this.usernameInput.getText();
    }

    private String getPassword() {
        return this.passwordInput.getText();
    }
}

