/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.MessageBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.event.RowSelectionEvent;
import org.gwt.mosaic.ui.client.event.RowSelectionHandler;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.engine.DeleteDeploymentAction;
import org.jboss.bpm.console.client.engine.DeploymentDetailView;
import org.jboss.bpm.console.client.engine.ResumeDeploymentAction;
import org.jboss.bpm.console.client.engine.SuspendDeploymentAction;
import org.jboss.bpm.console.client.engine.UpdateDeploymentDetailAction;
import org.jboss.bpm.console.client.engine.UpdateDeploymentsAction;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

public class DeploymentListView
implements ViewInterface,
WidgetProvider,
DataDriven {
    public static final String ID = DeploymentListView.class.getName();
    private Controller controller;
    private boolean initialized;
    private MosaicPanel deploymentList = null;
    private org.gwt.mosaic.ui.client.ListBox<DeploymentRef> listBox;
    private DeploymentRef selection = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private int FILTER_NONE = 10;
    private int FILTER_ACTIVE = 20;
    private int FILTER_SUSPENDED = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<DeploymentRef> deployments = null;
    private DeploymentDetailView detailView;
    MosaicPanel panel;
    private boolean isRiftsawInstance = false;

    public DeploymentListView() {
        this.controller = (Controller)Registry.get(Controller.class);
        ConsoleConfig config = ((ApplicationContext)Registry.get(ApplicationContext.class)).getConfig();
        this.isRiftsawInstance = config.getProfileName().equals("BPEL Console");
    }

    public void provideWidget(ProvisioningCallback callback) {
        this.panel = new MosaicPanel((LayoutManager)new BorderLayout());
        this.listBox = this.createListBox();
        this.initialize();
        this.panel.add((Widget)this.deploymentList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
        this.panel.add((Widget)this.detailView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 200.0));
        this.controller.addAction(UpdateDeploymentsAction.ID, (ActionInterface)new UpdateDeploymentsAction());
        this.controller.addAction(UpdateDeploymentDetailAction.ID, (ActionInterface)new UpdateDeploymentDetailAction());
        this.controller.addAction(DeleteDeploymentAction.ID, (ActionInterface)new DeleteDeploymentAction());
        this.controller.addAction(SuspendDeploymentAction.ID, (ActionInterface)new SuspendDeploymentAction());
        this.controller.addAction(ResumeDeploymentAction.ID, (ActionInterface)new ResumeDeploymentAction());
        this.controller.addView(ID, (ViewInterface)this);
        callback.onSuccess((Widget)this.panel);
    }

    private org.gwt.mosaic.ui.client.ListBox createListBox() {
        final org.gwt.mosaic.ui.client.ListBox listBox = new org.gwt.mosaic.ui.client.ListBox(new String[]{"Deployment", "Status"});
        listBox.setCellRenderer((ListBox.CellRenderer)new ListBox.CellRenderer<DeploymentRef>(){

            public void renderCell(org.gwt.mosaic.ui.client.ListBox<DeploymentRef> listBox, int row, int column, DeploymentRef item) {
                String color = item.isSuspended() ? "#CCCCCC" : "#000000";
                switch (column) {
                    case 0: {
                        String text = "<div style=\"color:" + color + "\">" + item.getName() + "</div>";
                        listBox.setWidget(row, column, (Widget)new HTML(text));
                        break;
                    }
                    case 1: {
                        String status = item.isSuspended() ? "retired" : "active";
                        String s = "<div style=\"color:" + color + "\">" + status + "</div>";
                        listBox.setWidget(row, column, (Widget)new HTML(status));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected column size");
                    }
                }
            }
        });
        listBox.addRowSelectionHandler(new RowSelectionHandler(){

            public void onRowSelection(RowSelectionEvent rowSelectionEvent) {
                int index = listBox.getSelectedIndex();
                if (index != -1) {
                    DeploymentRef item = (DeploymentRef)listBox.getItem(index);
                    DeploymentListView.this.controller.handleEvent(new Event(UpdateDeploymentDetailAction.ID, (Object)item));
                }
            }
        });
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.deploymentList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.deploymentList.setPadding(0);
            this.deploymentList.setWidgetSpacing(0);
            MosaicPanel toolBox = new MosaicPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(0);
            toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new Button("Refresh", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    DeploymentListView.this.reset();
                    DeploymentListView.this.controller.handleEvent(new Event(UpdateDeploymentsAction.ID, null));
                }
            }));
            Button deleteBtn = new Button("Delete", new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    DeploymentRef deploymentRef = DeploymentListView.this.getSelection();
                    if (deploymentRef != null) {
                        MessageBox.confirm((String)"Delete deployment", (String)"Do you want to delete this deployment? Any related data will be removed.", (MessageBox.ConfirmationCallback)new MessageBox.ConfirmationCallback(){

                            public void onResult(boolean doIt) {
                                if (doIt) {
                                    DeploymentListView.this.controller.handleEvent(new Event(DeleteDeploymentAction.ID, (Object)DeploymentListView.this.getSelection().getId()));
                                }
                            }
                        });
                    } else {
                        MessageBox.alert((String)"Missing selection", (String)"Please select a deployment");
                    }
                }
            });
            if (!this.isRiftsawInstance) {
                toolBar.add((Widget)deleteBtn);
            }
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            MosaicPanel filterPanel = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            filterPanel.setStyleName("mosaic-ToolBar");
            final ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Active");
            dropBox.addItem("Retired");
            dropBox.addChangeListener(new ChangeListener(){

                public void onChange(Widget sender) {
                    switch (dropBox.getSelectedIndex()) {
                        case 0: {
                            DeploymentListView.this.currentFilter = DeploymentListView.this.FILTER_NONE;
                            break;
                        }
                        case 1: {
                            DeploymentListView.this.currentFilter = DeploymentListView.this.FILTER_ACTIVE;
                            break;
                        }
                        case 2: {
                            DeploymentListView.this.currentFilter = DeploymentListView.this.FILTER_SUSPENDED;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("No such index");
                        }
                    }
                    DeploymentListView.this.renderFiltered();
                }
            });
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.VERTICAL));
            this.deploymentList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.deploymentList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.detailView = new DeploymentDetailView();
            this.controller.addView(DeploymentDetailView.ID, (ViewInterface)this.detailView);
            Timer t = new Timer(){

                public void run() {
                    DeploymentListView.this.controller.handleEvent(new Event(UpdateDeploymentsAction.ID, null));
                }
            };
            t.schedule(500);
            this.initialized = true;
        }
    }

    public DeploymentRef getSelection() {
        DeploymentRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = (DeploymentRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public void reset() {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        this.controller.handleEvent(new Event(UpdateDeploymentDetailAction.ID, null));
    }

    public void update(Object ... data) {
        this.deployments = (List)data[0];
        this.renderFiltered();
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.deploymentList, isLoading);
    }

    private void renderFiltered() {
        if (this.deployments != null) {
            this.reset();
            DefaultListModel model = (DefaultListModel)this.listBox.getModel();
            for (DeploymentRef dpl : this.deployments) {
                boolean showSuspended;
                if (this.FILTER_NONE == this.currentFilter) {
                    model.add((Object)dpl);
                    continue;
                }
                boolean bl = showSuspended = this.FILTER_SUSPENDED == this.currentFilter;
                if (dpl.isSuspended() != showSuspended) continue;
                model.add((Object)dpl);
            }
            if (this.listBox.getSelectedIndex() != -1) {
                this.listBox.setItemSelected(this.listBox.getSelectedIndex(), false);
            }
        }
    }

    public void select(String deploymentId) {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            DeploymentRef ref = (DeploymentRef)model.getElementAt(i);
            if (!ref.getId().equals(deploymentId)) continue;
            this.listBox.setSelectedIndex(i);
            break;
        }
    }
}

