/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.model;

import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
@XmlRootElement(name = "taskReference")
public class TaskRef
{
   private long id;
   private long tokenId;
   private long processInstanceId;
   private long processId;

   private String name;
   private String actor = "";

   private boolean isBlocking;
   private boolean isSignalling = true;

   private List<String> transitionNames = new ArrayList<String>();
   private List<String> pooledActors = new ArrayList<String>();

   public enum STATE {OPEN, ASSIGNED, CLOSED};
   private STATE currentState;

   public TaskRef()
   {
      initOrUpdateState();
   }

   public TaskRef(
         long taskId, long tokenId, long processInstanceId,
         long processId,
         String taskName, String actorName,
         boolean blocking, boolean signalling
   )
   {
      this.id = taskId;
      this.tokenId = tokenId;
      this.processInstanceId = processInstanceId;
      this.processId = processId;
      this.name = taskName;
      setActor(actorName);
      isBlocking = blocking;
      isSignalling = signalling;

      initOrUpdateState();
   }

   public long getId()
   {
      return id;
   }

   public void setId(long id)
   {
      this.id = id;
   }

   public long getTokenId()
   {
      return tokenId;
   }

   public void setTokenId(long tokenId)
   {
      this.tokenId = tokenId;
   }

   public long getProcessInstanceId()
   {
      return processInstanceId;
   }

   public void setProcessInstanceId(long processInstanceId)
   {
      this.processInstanceId = processInstanceId;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getActor()
   {
      return actor;
   }

   public void setActor(String actor)
   {
      if(null==actor)
         actor = "";
      
      this.actor = actor;
      initOrUpdateState();
   }

   public boolean isBlocking()
   {
      return isBlocking;
   }

   public void setBlocking(boolean blocking)
   {
      isBlocking = blocking;
   }

   public boolean isSignalling()
   {
      return isSignalling;
   }

   public void setSignalling(boolean signalling)
   {
      isSignalling = signalling;
   }

   public List<String> getTransitionNames()
   {
      return transitionNames;
   }

   public void setProcessId(long processId)
   {
      this.processId = processId;
   }

   public void setTransitionNames(List<String> transitionNames)
   {
      this.transitionNames = transitionNames;
   }

   public void setPooledActors(List<String> pooledActors)
   {
      this.pooledActors = pooledActors;
   }

   public void addPooledActor(String actorId)
   {
      pooledActors.add(actorId);

      initOrUpdateState();
   }

   private void initOrUpdateState()
   {
      if(actor==null || actor.equals(""))
      {
         currentState = STATE.OPEN;
      }
      else
      {
         currentState = STATE.ASSIGNED;
      }
   }

   public void close()
   {
      if(STATE.ASSIGNED != currentState)
         throw new IllegalArgumentException("Cannot close task in state " + currentState);

      currentState = STATE.CLOSED;
   }

   public long getProcessId()
   {
      return processId;
   }

   public STATE getCurrentState()
   {
      return currentState;
   }

   public String toString()
   {
      return "TaskRef{id:"+id+",state:"+currentState+"}";
   }

   public List<String> getPooledActors()
   {
      return pooledActors;
   }
}
