/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import com.google.gson.Gson;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.bpm.console.client.model.RoleAssignmentRef;
import org.jboss.bpm.console.client.model.RoleAssignmentRefWrapper;
import org.jboss.bpm.console.server.gson.GsonFactory;
import org.jboss.bpm.console.server.integration.ManagementFactory;
import org.jboss.bpm.console.server.integration.UserManagement;
import org.jboss.bpm.console.server.util.ProjectName;
import org.jboss.bpm.console.server.util.RsComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="identity")
@RsComment(title="User management", description="Manage user and groups", project={ProjectName.JBPM})
public class UserMgmtFacade {
    private static final Logger log = LoggerFactory.getLogger(UserMgmtFacade.class);
    private UserManagement userManagement;

    private UserManagement getUserManagement() {
        if (null == this.userManagement) {
            ManagementFactory factory = ManagementFactory.newInstance();
            this.userManagement = factory.createUserManagement();
        }
        return this.userManagement;
    }

    @GET
    @Path(value="sid")
    @Produces(value={"text/plain"})
    public Response getSessionID(@Context HttpServletRequest request) {
        return Response.ok((Object)request.getSession().getId()).build();
    }

    @POST
    @Path(value="sid/invalidate")
    @Produces(value={"text/plain"})
    public Response destroySession(@Context HttpServletRequest request) {
        request.getSession().invalidate();
        return Response.ok().build();
    }

    @GET
    @Path(value="secure/sid")
    @Produces(value={"text/plain"})
    public Response getSessionIDSecure(@Context HttpServletRequest request) {
        return Response.ok((Object)request.getSession().getId()).build();
    }

    @GET
    @Path(value="user/current")
    @Produces(value={"application/json"})
    public Response getCurrentUser(@Context HttpServletRequest request) {
        String user = null;
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            user = principal.getName();
        }
        if (user == null) {
            user = request.getRemoteUser();
        }
        return this.createJsonResponse((Object)user);
    }

    @GET
    @Path(value="user/roles")
    @Produces(value={"application/json"})
    public Response getRolesForJAASPrincipal(@Context HttpServletRequest request, @QueryParam(value="roleCheck") String roleCheck) {
        if (null == roleCheck) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Missing parameter 'roleCheck'"));
        }
        log.debug("Role check user: " + request.getUserPrincipal().getName() + ", actualRoles requested: " + roleCheck);
        ArrayList<RoleAssignmentRef> actualRoles = new ArrayList<RoleAssignmentRef>();
        StringTokenizer tok = new StringTokenizer(roleCheck, ",");
        while (tok.hasMoreTokens()) {
            String possibleRole = tok.nextToken();
            actualRoles.add(new RoleAssignmentRef(possibleRole, request.isUserInRole(possibleRole)));
        }
        return this.createJsonResponse((Object)new RoleAssignmentRefWrapper(actualRoles));
    }

    @GET
    @Path(value="user/{actorId}/groups/")
    @Produces(value={"application/json"})
    public Response getGroupsForActor(@PathParam(value="actorId") String actorId) {
        List groups = this.getUserManagement().getGroupsForActor(actorId);
        return this.createJsonResponse((Object)groups);
    }

    @GET
    @Path(value="group/{groupName}/members")
    @Produces(value={"application/json"})
    public Response getActorsForGroup(@PathParam(value="groupName") String groupName) {
        List groups = this.getUserManagement().getActorsForGroup(groupName);
        return this.createJsonResponse((Object)groups);
    }

    @GET
    @Path(value="user/{actorId}/actors")
    @Produces(value={"application/json"})
    public Response getAvailableActors(@PathParam(value="actorId") String actorId) {
        HashSet users = new HashSet();
        List groups = this.getUserManagement().getGroupsForActor(actorId);
        for (String group : groups) {
            List actors = this.getUserManagement().getActorsForGroup(group);
            users.addAll(actors);
        }
        ArrayList availableActors = new ArrayList();
        availableActors.addAll(users);
        availableActors.addAll(groups);
        return this.createJsonResponse(availableActors);
    }

    private Response createJsonResponse(Object wrapper) {
        Gson gson = GsonFactory.createInstance();
        String json = gson.toJson(wrapper);
        return Response.ok((Object)json).type("application/json").build();
    }
}

