/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.bpm.console.server.integration.ManagementFactory;
import org.jboss.bpm.console.server.integration.TaskManagement;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jboss.bpm.console.server.plugin.PluginMgr;
import org.jboss.bpm.console.server.util.ProjectName;
import org.jboss.bpm.console.server.util.RsComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="task")
@RsComment(title="Task Management", description="Manage task instances", project={ProjectName.JBPM})
public class TaskMgmtFacade {
    private static final Logger log = LoggerFactory.getLogger(TaskMgmtFacade.class);
    private TaskManagement taskManagement;
    private FormDispatcherPlugin formPlugin;

    private TaskManagement getTaskManagement() {
        if (null == this.taskManagement) {
            ManagementFactory factory = ManagementFactory.newInstance();
            this.taskManagement = factory.createTaskManagement();
            log.debug("Using ManagementFactory impl:" + factory.getClass().getName());
        }
        return this.taskManagement;
    }

    private FormDispatcherPlugin getFormDispatcherPlugin() {
        if (null == this.formPlugin) {
            this.formPlugin = (FormDispatcherPlugin)PluginMgr.load(FormDispatcherPlugin.class);
            log.debug("Using FormDispatcherPlugin impl:" + this.formPlugin);
        }
        return this.formPlugin;
    }

    @POST
    @Path(value="{taskId}/assign/{ifRef}")
    @Produces(value={"application/json"})
    public Response assignTask(@Context HttpServletRequest request, @PathParam(value="taskId") long taskId, @PathParam(value="ifRef") String idRef) {
        log.debug("Assign task " + taskId + " to '" + idRef + "'");
        this.getTaskManagement().assignTask(taskId, idRef, request.getUserPrincipal().getName());
        return Response.ok().build();
    }

    @POST
    @Path(value="{taskId}/release")
    @Produces(value={"application/json"})
    public Response releaseTask(@Context HttpServletRequest request, @PathParam(value="taskId") long taskId) {
        log.debug("Release task " + taskId);
        this.getTaskManagement().assignTask(taskId, null, request.getUserPrincipal().getName());
        return Response.ok().build();
    }

    @POST
    @Path(value="{taskId}/close")
    @Produces(value={"application/json"})
    public Response closeTask(@Context HttpServletRequest request, @PathParam(value="taskId") long taskId) {
        log.debug("Close task " + taskId);
        this.getTaskManagement().completeTask(taskId, null, request.getUserPrincipal().getName());
        return Response.ok().build();
    }

    @POST
    @Path(value="{taskId}/close/{outcome}")
    @Produces(value={"application/json"})
    public Response closeTaskWithSignal(@Context HttpServletRequest request, @PathParam(value="taskId") long taskId, @QueryParam(value="outcome") String outcome) {
        log.debug("Close task " + taskId + " outcome " + outcome);
        this.getTaskManagement().completeTask(taskId, outcome, null, request.getUserPrincipal().getName());
        return Response.ok().build();
    }
}

