/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.allen_sauer.gwt.log.client.Log;

/**
 * Setup the main {@link com.mvc4g.client.Controller} and fire
 * a login event.
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Application implements EntryPoint
{

  public void onModuleLoad() {
    Log.setUncaughtExceptionHandler();

    DeferredCommand.addCommand(new Command() {
      public void execute() {
        onModuleLoad2();
      }
    });
  }
  
  public void onModuleLoad2()
  {
    Controller mainController = new com.mvc4g.client.Controller();
    mainController.addAction("login", new LoginAction());
    mainController.addView("loginView", new LoginView());
    mainController.handleEvent(new Event("login", null));    
  }
}
