/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.*;
import com.google.gwt.user.client.Timer;
import com.google.gwt.core.client.GWT;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;

import java.util.List;

import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Header extends HorizontalPanel implements ViewInterface
{
  public final static String ID = Header.class.getName();

  private ApplicationContext appContext;
  private Controller controller;
  private Image loadingImage;

  // avoid flickering image
  final Timer turnOffLoading = new Timer() {
    public void run() {
      loadingImage.setVisible(false);
    }
  };

  public Header(ApplicationContext appContext, String username, List<String> roles)
  {
    super();
    this.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
    this.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
    this.setStyleName("bpm-header");

    this.appContext = appContext;

    createInfoPanel();
  }

  private void createInfoPanel()
  {
    // user info
    HorizontalPanel p = new HorizontalPanel();
    p.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
    p.setStyleName("bpm-header-userinfo");

    // load status image
    LayoutPanel loadingImageContainer = new LayoutPanel();
    loadingImageContainer.setStyleName("bpm-loading-image");

    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);
    loadingImage = new Image("images/icons/loading.gif");
    loadingImageContainer.add(loadingImage);
    
    setLoading(false);

    // account info
    Image img = icons.userIcon().createImage();
    HTML html = new HTML(appContext.getAuthentication().getUsername());

    Button btn = new Button("Logout", new ClickListener()
    {

      public void onClick(Widget widget)
      {
        appContext.getAuthentication().doLogout();
      }
    }
    );

    p.add(loadingImageContainer);
    p.add(img);
    p.add(html);
    p.add(btn);

    this.add(p);

  }


  public void setController(Controller controller)
  {
    this.controller = controller;
  }

  public void setLoading(boolean doDisplay)
  {
    if(doDisplay)
      loadingImage.setVisible(doDisplay);
    else
      turnOffLoading.schedule(1000);
  }
}
