/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.ui.*;
import com.google.gwt.core.client.GWT;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.forms.client.builder.DefaultFormBuilder;
import org.gwt.mosaic.forms.client.layout.FormLayout;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.Authentication;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.MainLayout;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.util.ConsoleLog;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class LoginView implements ViewInterface
{
  public final static String NAME = "loginView";

  private ConsoleConfig config;
  private URLBuilder urlBuilder;
  private Authentication auth;

  private WindowPanel window = null;
  private TextBox usernameInput;
  private PasswordTextBox passwordInput;

  public final static String[] KNOWN_ROLES = {"admin", "manager", "user"};

  private Controller controller;

  public LoginView()
  {
    config = new ConsoleConfig();

    // setup

    if (!GWT.isScript())
    {
      String proxyUrl = GWT.getModuleBaseURL() + "xhp";
      config.setConsoleServerUrl(proxyUrl);
    }

    ConsoleLog.debug("Console server: " + config.getConsoleServerUrl());
    ConsoleLog.debug("Report server: " + config.getReportServerUrl());

    urlBuilder = new URLBuilder(config);

  }

  public void setController(Controller controller)
  {
    this.controller = controller;
  }

  public void display()
  {
    createLayoutWindowPanel();   
    window.center();
  }

  /**
   * The 'layout' window panel.
   */
  private void createLayoutWindowPanel() {
    window = new WindowPanel("jBPM Management Console");
    window.setAnimationEnabled(false);
    window.setSize("320px", "180px");    
    
    LayoutPanel panel = new LayoutPanel();
    createLayoutContent(panel);
    window.setWidget(panel);

    window.addWindowCloseListener(new WindowCloseListener() {
      public void onWindowClosed() {
        window = null;
      }

      public String onWindowClosing() {
        return null;
      }
    });
  }

  /**
   * Create content for layout.
   */
  private void createLayoutContent(LayoutPanel layoutPanel) {

    layoutPanel.setLayout(new BorderLayout());
    layoutPanel.setPadding(5);

    final Button submit = new Button("Submit");
    submit.addClickListener(new ClickListener()
    {

      public void onClick(Widget widget)
      {
        String user = usernameInput.getText();
        String pass = passwordInput.getText();

        String url = urlBuilder.getUserInRoleURL(KNOWN_ROLES);
        auth = new Authentication(url);
        auth.setCallback(
            new Authentication.AuthCallback()
            {

              public void onLoginSuccess(Request request, Response response)
              {
                // clear the form
                usernameInput.setText("");
                passwordInput.setText("");

                // display main console
                window.hide();

                // assemble main layout                
                new MainLayout(controller, auth, urlBuilder, config);
              }

              public void onLoginFailed(Request request, Throwable t)
              {
                // auth failed
                ConsoleLog.error("Authentication failed.", t);
              }
            }
        );

        auth.doLogin(user, pass);
      }
    });

    // TODO: does this load the imagebundle already?
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    LayoutPanel imgPanel = new LayoutPanel();
    imgPanel.add(icons.userIcon().createImage());
    imgPanel.setVisible(false);
    
    layoutPanel.add(imgPanel, new BorderLayoutData(BorderLayout.Region.NORTH, 50, 200));
    layoutPanel.add(createForm(), new BorderLayoutData(BorderLayout.Region.CENTER, 10, 200));
    layoutPanel.add(submit, new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));

  }

  private Widget createForm()
  {
    FormLayout layout = new FormLayout(
        "right:pref, 10px, left:pref:grow",   // 3 columns
        "pref, pref, 5px, pref");             // 4 rows

    DefaultFormBuilder builder = new DefaultFormBuilder(layout);
    builder.appendSeparator("Login");

    usernameInput = new TextBox();
    builder.append("Username:", usernameInput);
    builder.nextLine();

    builder.nextLine();   // empty space

    passwordInput = new PasswordTextBox();
    builder.append("Password:", passwordInput);
    builder.nextLine();

    return builder.getPanel();
  }
}
