/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.allen_sauer.gwt.log.client.DivLogger;
import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.*;
import com.google.gwt.user.client.ui.HTML;
import com.mvc4g.client.Controller;
import org.gwt.mosaic.ui.client.*;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import static org.gwt.mosaic.ui.client.layout.BorderLayout.Region;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.util.ButtonHelper;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.util.WindowUtil;

/**
 * The main composite that assembles the gwt console application.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class MainLayout extends Composite implements ApplicationContext
{

  public final static String NAME = "mainLayout";

  private Header header;
  private Menu menu;

  private Workspace workspace;
  private URLBuilder urlBuilder;
  private Authentication auth;
  private ConsoleConfig config;

  private Controller controller;
  private Viewport viewport;

  public MainLayout(Controller controller, Authentication auth, URLBuilder urlBuilder, ConsoleConfig config)
  {
    this.controller = controller;
    this.auth = auth;
    this.config = config;
    this.urlBuilder = urlBuilder;

    display();
  }

  public void display()
  {
    viewport = new Viewport();

    // manually, otherwise it will appear on the login screen
    Log.addLogger(new DivLogger());

    LayoutPanel layout = createLayout();
    viewport.add(layout);

    RootPanel.get().add(viewport);


  }

  private LayoutPanel createLayout()
  {
    final LayoutPanel layoutPanel = new LayoutPanel(new BorderLayout());

    // header
    header = new Header(this, auth.getUsername(), auth.getRolesAssigned());
    layoutPanel.add(header, new BorderLayoutData(Region.NORTH, 50));

    // menu
    menu = new Menu();
    layoutPanel.add(menu, new BorderLayoutData(Region.WEST, 200));

    // workspace
    workspace = createWorkspace();
    layoutPanel.add(workspace, new BorderLayoutData(Region.CENTER, false));


    // register views and actions
    controller.addView(Header.ID, header);

    controller.addAction(LoadingStatusAction.ID, new LoadingStatusAction());

    // message Panel    
    final CaptionLayoutPanel messagePanel = createMessagePanel(layoutPanel);
    messagePanel.add(Log.getDivLogger().getWidget());
    messagePanel.setCollapsed(true);
    layoutPanel.add(messagePanel, new BorderLayoutData(Region.SOUTH, true));

    // Turn on DivLogger
    Log.getDivLogger().getWidget().setVisible(true);

    // default editor
    if(workspace.hasEditor(SettingsEditor.ID))
      workspace.showEditor(SettingsEditor.ID);

    return layoutPanel;
  }

  private CaptionLayoutPanel createMessagePanel(final LayoutPanel layoutPanel)
  {
    final CaptionLayoutPanel messagePanel = new CaptionLayoutPanel("Messages", true);

    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);
    Button collapse = new Button(
        ButtonHelper.createButtonLabel(
            icons.collapseDownIcon(),
            "",
            ButtonHelper.ButtonLabelType.TEXT_ON_TOP)
    );
    collapse.addClickListener(
        new ClickListener()
        {
          public void onClick(Widget sender)
          {
            messagePanel.setCollapsed(!messagePanel.isCollapsed());
            layoutPanel.layout();
          }
        }
    );

    messagePanel.getHeader().add(
        collapse,
        Caption.CaptionRegion.RIGHT
    );
    return messagePanel;
  }

  private Workspace createWorkspace()
  {
    Workspace workspace = new Workspace(menu);
    WorkspaceLauncher launcher = GWT.create(WorkspaceLauncher.class);
    launcher.launch(this, workspace);    // calls Workspace.addEditor()
    return workspace;
  }

  // ---- ApplicationContext interface ----


  public Viewport getViewport()
  {
    return viewport;
  }

  public Controller getController()
  {
    return this.controller;
  }

  public URLBuilder getUrlBuilder()
  {
    return this.urlBuilder;
  }

  public void displayMessage(final String message, final boolean isError)
  {
    if(isError)
    {
      WindowPanel err = new WindowPanel("Error");
      err.getHeader().add( new Image("images/icons/error.png") );
      err.setAnimationEnabled(true);
      err.setSize("320px", "240px");
      ScrollLayoutPanel scrollLayoutPanel = new ScrollLayoutPanel();
      scrollLayoutPanel.add(new HTML(message));
      err.setWidget(scrollLayoutPanel);

      WindowUtil.addMaximizeButton(err, Caption.CaptionRegion.RIGHT);
      WindowUtil.addMinimizeButton(err, Caption.CaptionRegion.RIGHT);

      err.center();
    }
    else
    {
      InfoPanel.show("", message, "");
    }
  }

  public Authentication getAuthentication()
  {
    return auth;
  }

  public ConsoleConfig getConfig()
  {
    return config;
  }

  public Workspace getWorkpace()
  {
    return workspace;
  }

  /**
   * hack in order to correctly display widgets that have
   * been rendered hidden
   */
  public void refreshView()
  {
    final int width = Window.getClientWidth();
    final int height = Window.getClientHeight();
    getViewport().onWindowResized(width, height);
  }
}

