/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.Label;
import org.jboss.bpm.console.client.model.ServerStatus;
import org.jboss.bpm.console.client.model.PluginInfo;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ServerStatusView extends LayoutPanel
  implements ViewInterface
{

  public final static String ID = ServerStatusView.class.getName();

  private Controller controller;
  private LayoutPanel container; 
  private ApplicationContext appContext;
  
  public ServerStatusView(ApplicationContext appContext)
  {
    this.appContext = appContext;
    container = new LayoutPanel();    

  }

  public void setController(Controller controller)
  {
    this.controller = controller;
  }

  public void update(ServerStatus status)
  {    
    Grid g = new Grid(status.getPlugins().size()+1, 2);
    
    g.setWidget(0, 0, new Label("Plugins:"));

    for (int row = 1; row < status.getPlugins().size()+1; ++row)
    {
      PluginInfo p = status.getPlugins().get(row-1);
      g.setText(row, 0, p.getType());
      g.setStyleName("bpm-info-table");
      
      final Image img = p.isAvailable() ?
          new Image("images/icons/confirm_small.png"):
          new Image("images/icons/deny_small.png");
      
      g.setWidget(row, 1, img );
    }

    container.add(g);
    this.add(container);
    
    this.invalidate();
    appContext.refreshView();
  }
}
