/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.*;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.core.client.GWT;
import com.mvc4g.client.Event;
import org.gwt.mosaic.ui.client.*;
import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.layout.*;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class SettingsEditor extends Editor
{

  public final static String ID = SettingsEditor.class.getName();

  private TabLayoutPanel tabPanel;

  public SettingsEditor(ApplicationContext appContext)
  {
    super(appContext);
  }

  public void initialize()
  {
    if(!isInitialized())
    {

      tabPanel = new DecoratedTabLayoutPanel();
      tabPanel.setPadding(5);

      final ScrollLayoutPanel layoutPanel = new ScrollLayoutPanel(
          new BoxLayout(BoxLayout.Orientation.VERTICAL)
      );

      // console info
      StringBuffer sb = new StringBuffer();
      sb.append("<table>");
      sb.append("<tr>");
      sb.append("<td colspan=2><h3>Console Info</h3></td>");      
      sb.append("</tr>");

      sb.append("<tr>");
      sb.append("<td>Version: </td>");
      sb.append("<td>"+Version.VERSION+"</td>");
      sb.append("</tr>");

      sb.append("<tr>");
      sb.append("<td colspan=2><br/></td>");      
      sb.append("</tr>");

      sb.append("<tr>");
      sb.append("<td colspan=2><h3>Server Info</h3></td>");
      sb.append("</tr>");

      sb.append("<tr>");
      sb.append("<td>Host: </td>");
      sb.append("<td>"+appContext.getConfig().getConsoleServerUrl()+"</td>");
      sb.append("</tr>");

      sb.append("</table>");

      layoutPanel.add(new HTML(sb.toString()));
      ServerStatusView serverStatus = new ServerStatusView(appContext);
      layoutPanel.add(serverStatus); // Doesn't render in grid
      

      tabPanel.add(layoutPanel, "System Overview");

      this.add(tabPanel, new BorderLayoutData(BorderLayout.Region.CENTER));

      // view and actions

      super.controller.addView(ServerStatusView.ID, serverStatus);
      super.controller.addAction(ServerStatusAction.ID, new ServerStatusAction(appContext));

      // load server status
      super.controller.handleEvent(
          new Event(ServerStatusAction.ID, null)
      );
      isInitialized = true;
    }

  }

  public String getEditorId()
  {
    return ID;
  }

  public String getTitle()
  {
    return "Settings";
  }

  public String getIconCSS()
  {
    return "bpm-settings-editor";
  }

  public MenuSection provideMenuSection()
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    return new MenuSection(
        "Settings",
        icons.settingsIcon(),
        new SettingsEditorNavigation(appContext)
    );

  }
}
