/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.GWT;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.MessageBox;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.common.AbstractView;

import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
class DefinitionListView extends AbstractView
{
  public final static String ID = DefinitionListView.class.getName();

  private Controller controller;

  private LayoutPanel definitionList = null;

  private ListBox<ProcessDefinitionRef> listBox;

  private boolean isInitialized;

  public DefinitionListView()
  {
    super();
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);
    setTitle("Process Definitions");
    setIcon(icons.processIcon());
  }

  public boolean isInitialized()
  {
    return isInitialized;
  }

  public void initialize()
  {
    if(!isInitialized)
    {
      definitionList = new LayoutPanel( new BoxLayout(BoxLayout.Orientation.VERTICAL));
      definitionList.setPadding(0);
      definitionList.setWidgetSpacing(0);

      listBox =
          new ListBox<ProcessDefinitionRef>(
              new String[] {
                  "Process ID", "Name", "Key", "Version"}
          );


      listBox.setCellRenderer(new ListBox.CellRenderer<ProcessDefinitionRef>() {
        public void renderCell(ListBox<ProcessDefinitionRef> listBox, int row, int column,
                               ProcessDefinitionRef item) {
          switch (column) {
            case 0:
              listBox.setText(row, column, item.getId());
              break;
            case 1:
              listBox.setText(row, column, item.getName());
              break;
            case 2:
              listBox.setText(row, column, item.getKey());
              break;
            case 3:
              listBox.setText(row, column, String.valueOf(item.getVersion()));
              break;
            default:
              throw new RuntimeException("Unexpected column size");
          }
        }
      });

      listBox.addChangeListener(new ChangeListener()
      {
        public void onChange(Widget widget)
        {
          int index = listBox.getSelectedIndex();
          if(index!=-1)
          {
            controller.handleEvent(
                new Event(
                    LoadInstancesAction.ID,
                    listBox.getItem( index )
                )
            );
          }
        }
      });

      final DefaultListModel<ProcessDefinitionRef> model =
          (DefaultListModel<ProcessDefinitionRef>) listBox.getModel();

      // toolbar

      final LayoutPanel toolBox = new LayoutPanel();
      toolBox.setPadding(0);
      toolBox.setWidgetSpacing(5);
      //toolBox.setLayout(new BoxLayout(BoxLayout.Orientation.VERTICAL));

      final ToolBar toolBar = new ToolBar();
      toolBar.add(
          new ToolButton("Refresh", new ClickListener() {
            public void onClick(Widget sender) {
              // force loading
              controller.handleEvent(
                  new Event(LoadDefinitionsAction.ID, null)
              );
            }
          }
          )
      );

      toolBar.addSeparator();

      toolBar.add(
          new ToolButton("Delete", new ClickListener() {
            public void onClick(Widget sender) {
              // force loading
              ProcessDefinitionRef definitionRef = getSelection();
              if(definitionRef!=null)
              {
              controller.handleEvent(
                  new Event(DeleteDefinitionAction.ID, definitionRef)
              );
              }
              else
              {
                MessageBox.alert("Missing selection", "Please select a process definition");
              }
            }
          }
          )
      );
      
      toolBox.add(toolBar, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

      this.definitionList.add(toolBox, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
      this.definitionList.add(listBox, new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));

      this.add(definitionList);

      isInitialized = true;
    }
  }


  public void setController(Controller controller)
  {
    this.controller = controller;
  }

  public void update(List<ProcessDefinitionRef> definitions)
  {
    // lazy init
    initialize();

    final DefaultListModel<ProcessDefinitionRef> model =
        (DefaultListModel<ProcessDefinitionRef>) listBox.getModel();

    model.clear();

    for(ProcessDefinitionRef def : definitions)
    {
      model.add(def);
    }
  }

  public ProcessDefinitionRef getSelection()
  {
    ProcessDefinitionRef selection = null;
    if(isInitialized() && listBox.getSelectedIndex()!=-1)
      selection = listBox.getItem( listBox.getSelectedIndex());
    return selection;
  }
}
