/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.mvc4g.client.Controller;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.common.AbstractRESTAction;
import org.jboss.bpm.console.client.model.DTOParser;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;

import java.util.List;

/**
 * Loads a process definition list.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
class LoadDefinitionsAction extends AbstractRESTAction
{
  public final static String ID = LoadDefinitionsAction.class.getName();

  public LoadDefinitionsAction(ApplicationContext appContext)
  {
    super(appContext);
  }

  public String getId()
  {
    return ID;
  }

  public String getUrl(Object event)
  {
    return appContext.getUrlBuilder().getProcessDefinitionsURL();
  }

  public RequestBuilder.Method getRequestMethod()
  {
    return RequestBuilder.GET;
  }

  public void handleSuccessfulResponse(final Controller controller, final Object event, Response response)
  {
    if (200 == response.getStatusCode())
    {
      JSONValue json = JSONParser.parse(response.getText());
      List<ProcessDefinitionRef> definitions = DTOParser.parseProcessDefinitions(json);
      DefinitionListView view = (DefinitionListView) controller.getView(DefinitionListView.ID);
      view.update(definitions);

      ConsoleLog.info("Loaded " + definitions.size() + " process definitions");
    }
    else
    {
      // Handle the error.  Can get the status text from response.getStatusText()
      String message = "Failed to load instances. " +
          "HTTP " + response.getStatusCode() +
          ": " + response.getText();
      ConsoleLog.error(message);
      appContext.displayMessage(message,true);
    }
  }
}
