/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Event;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.MessageBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.events.TaskIdentityEvent;

import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
class OpenTasksView extends AbstractTaskList
{

  public final static String ID = OpenTasksView.class.getName();

  public OpenTasksView()
  {
    super();
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);
    setTitle("Open Tasks");
    setIcon(icons.taskIcon());
  }

  public void initialize()
  {
    if(!isInitialized)
    {
      taskList = new LayoutPanel( new BoxLayout(BoxLayout.Orientation.VERTICAL));
      taskList.setPadding(0);
      taskList.setWidgetSpacing(0);

      listBox =
          new ListBox<TaskRef>(
              new String[] {
                  "Task ID", "Name", "Status"}
          );


      listBox.setCellRenderer(new ListBox.CellRenderer<TaskRef>() {
        public void renderCell(ListBox<TaskRef> listBox, int row, int column,
                               TaskRef item) {
          switch (column) {
            case 0:
              listBox.setText(row, column, String.valueOf(item.getId()));
              break;
            case 1:
              listBox.setText(row, column, item.getName());
              break;
            case 2:
              listBox.setText(row, column, String.valueOf(item.getCurrentState()));
              break;
            default:
              throw new RuntimeException("Unexpected column size");
          }
        }
      });
      
      // toolbar
      final LayoutPanel toolBox = new LayoutPanel();
      toolBox.setPadding(0);
      toolBox.setWidgetSpacing(5);

      final ToolBar toolBar = new ToolBar();
      toolBar.add(
          new ToolButton("Refresh", new ClickListener() {
            public void onClick(Widget sender) {
              // force loading
              controller.handleEvent(
                  new Event(LoadTasksAction.ID, getAssignedIdentity())
              );
            }
          }
          )
      );

      toolBar.addSeparator();

      toolBar.add(
          new ToolButton("Claim", new ClickListener() {
            public void onClick(Widget sender)
            {
              TaskRef selection = getSelection();

              if(selection!=null)
              {                
                controller.handleEvent(
                    new Event(
                        ClaimTaskAction.ID,
                        new TaskIdentityEvent(getAssignedIdentity(), selection)
                    )
                );
              }
              else
              {
                MessageBox.alert("Missing selection", "Please select a task");
              }
            }
          }
          )
      );

      toolBox.add(toolBar, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

      this.taskList.add(toolBox, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
      this.taskList.add(listBox, new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));

      this.add(taskList);

      isInitialized = true;
    }
  }

  public void update(String identity, List<TaskRef> tasks)
  {

    this.identity = identity;

    // lazy init
    initialize();

    final DefaultListModel<TaskRef> model =
        (DefaultListModel<TaskRef>) listBox.getModel();

    model.clear();

    for(TaskRef task : tasks)
    {
      if(TaskRef.STATE.OPEN ==task.getCurrentState())
        model.add(task);
    }
  }

}
