/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.SourcesTabEvents;
import com.google.gwt.user.client.ui.TabListener;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Event;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.TabLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.MenuSection;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class TaskEditor extends Editor
{
  public final static String ID = TaskEditor.class.getName();

  private TabLayoutPanel tabPanel;

  public TaskEditor(ApplicationContext appContext)
  {
    super(appContext);
  }

  public void initialize()
  {
    if(!isInitialized)
    {
      // create inner tab layout
      tabPanel = new DecoratedTabLayoutPanel();
      tabPanel.setPadding(5);
      tabPanel.addTabListener(
          new TabListener()
          {
            public boolean onBeforeTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              return true;
            }

            public void onTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              LazyPanel lazyPanel = (LazyPanel) tabPanel.getWidget(i);
              if(!lazyPanel.isInitialized())
              {
                lazyPanel.initialize();
                appContext.refreshView(); // TODO: hack around rendering problems
              }
            }
          }
      );

      this.add(tabPanel, new BorderLayoutData(BorderLayout.Region.CENTER));

      // create and register views
      registerView(OpenTasksView.ID, new OpenTasksView());
      registerView(AssignedTasksView.ID, new AssignedTasksView(appContext));

      // create and register actions
      registerAction(LoadTasksAction.ID, new LoadTasksAction(appContext));
      registerAction(ClaimTaskAction.ID, new ClaimTaskAction(appContext));
      registerAction(ReleaseTaskAction.ID, new ReleaseTaskAction(appContext));

      // display tab, needs to visible for correct rendering
      tabPanel.selectTab(0);

      // force loading
      super.controller.handleEvent(
          new Event(LoadTasksAction.ID, appContext.getAuthentication().getUsername())
      );

      appContext.refreshView();

      isInitialized = true;
    }
  }

  private void registerView(String id, AbstractView view)
  {
    // register view with controller
    super.controller.addView(id, view);

    // add to tab layout
    this.tabPanel.add(view, view.getIconTitle(), true);
  }

  private void registerAction(String name, ActionInterface action)
  {
    super.controller.addAction(name, action);
  }

  public String getEditorId()
  {
    return ID;
  }

  public String getTitle()
  {
    return "Task Management";
  }

  public String getIconCSS()
  {
    return "bpm-task-icon";
  }

  public MenuSection provideMenuSection()
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    return new MenuSection(
        "Tasks",
        icons.taskIcon(),
        new TaskEditorNavigation(appContext)
    );
  }
}
