/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonArrayDeserializationVisitor;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonObjectDeserializationVisitor;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonPrimitiveDeserializationVisitor;
import com.google.gson.MappedObjectConstructor;
import com.google.gson.ObjectConstructor;
import com.google.gson.ObjectNavigator;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonDeserializationContextDefault
implements JsonDeserializationContext {
    private final ObjectNavigatorFactory navigatorFactory;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private final MappedObjectConstructor objectConstructor;
    private final TypeAdapter typeAdapter;

    JsonDeserializationContextDefault(ObjectNavigatorFactory navigatorFactory, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, MappedObjectConstructor objectConstructor, TypeAdapter typeAdapter) {
        this.navigatorFactory = navigatorFactory;
        this.deserializers = deserializers;
        this.objectConstructor = objectConstructor;
        this.typeAdapter = typeAdapter;
    }

    public <T> T deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
        if (json.isJsonArray()) {
            return (T)this.fromJsonArray(typeOfT, json.getAsJsonArray(), (JsonDeserializationContext)this);
        }
        if (json.isJsonObject()) {
            return (T)this.fromJsonObject(typeOfT, json.getAsJsonObject(), (JsonDeserializationContext)this);
        }
        if (json.isJsonPrimitive()) {
            return (T)this.fromJsonPrimitive(typeOfT, json.getAsJsonPrimitive(), (JsonDeserializationContext)this);
        }
        if (json.isJsonNull()) {
            return null;
        }
        throw new JsonParseException("Failed parsing JSON source: " + json + " to Json");
    }

    private <T> T fromJsonArray(Type arrayType, JsonArray jsonArray, JsonDeserializationContext context) throws JsonParseException {
        JsonArrayDeserializationVisitor visitor = new JsonArrayDeserializationVisitor(jsonArray, arrayType, this.navigatorFactory, (ObjectConstructor)this.objectConstructor, this.typeAdapter, this.deserializers, context);
        Object target = visitor.getTarget();
        ObjectNavigator on = this.navigatorFactory.create(target, arrayType);
        on.accept((ObjectNavigator.Visitor)visitor);
        return (T)visitor.getTarget();
    }

    private <T> T fromJsonObject(Type typeOfT, JsonObject jsonObject, JsonDeserializationContext context) throws JsonParseException {
        JsonObjectDeserializationVisitor visitor = new JsonObjectDeserializationVisitor((JsonElement)jsonObject, typeOfT, this.navigatorFactory, (ObjectConstructor)this.objectConstructor, this.typeAdapter, this.deserializers, context);
        Object target = visitor.getTarget();
        ObjectNavigator on = this.navigatorFactory.create(target, typeOfT);
        on.accept((ObjectNavigator.Visitor)visitor);
        return (T)visitor.getTarget();
    }

    private <T> T fromJsonPrimitive(Type typeOfT, JsonPrimitive json, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitiveDeserializationVisitor visitor = new JsonPrimitiveDeserializationVisitor(json, typeOfT, this.navigatorFactory, (ObjectConstructor)this.objectConstructor, this.typeAdapter, this.deserializers, context);
        Object target = visitor.getTarget();
        ObjectNavigator on = this.navigatorFactory.create(target, typeOfT);
        on.accept((ObjectNavigator.Visitor)visitor);
        target = visitor.getTarget();
        if (typeOfT instanceof Class) {
            target = this.typeAdapter.adaptType(target, (Class)typeOfT);
        }
        return (T)target;
    }
}

