/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializationVisitor;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.ObjectConstructor;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonObjectDeserializationVisitor<T>
extends JsonDeserializationVisitor<T> {
    JsonObjectDeserializationVisitor(JsonElement json, Type type, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, TypeAdapter typeAdapter, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        super(json, type, factory, objectConstructor, typeAdapter, deserializers, context);
    }

    protected T constructTarget() {
        return (T)this.objectConstructor.construct(this.targetType);
    }

    public void startVisitingObject(Object node) {
    }

    public void endVisitingObject(Object node) {
    }

    public void visitCollection(Collection collection, Type componentType) {
        throw new IllegalStateException();
    }

    public void visitArray(Object array, Type componentType) {
        throw new IllegalStateException();
    }

    public void visitPrimitiveValue(Object obj) {
        throw new IllegalStateException();
    }

    public void visitObjectField(Field f, Type typeOfF, Object obj) {
        try {
            JsonObject jsonObject = this.json.getAsJsonObject();
            String fName = this.getFieldName(f);
            JsonElement jsonChild = jsonObject.get(fName);
            if (jsonChild != null) {
                Object child = this.visitChildAsObject(typeOfF, jsonChild);
                f.set(obj, child);
            } else {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitCollectionField(Field f, Type typeOfF, Object obj) {
        try {
            JsonObject jsonObject = this.json.getAsJsonObject();
            String fName = this.getFieldName(f);
            JsonArray jsonArray = (JsonArray)jsonObject.get(fName);
            if (jsonArray != null) {
                Collection collection = (Collection)this.objectConstructor.construct(typeOfF);
                f.set(obj, collection);
                Type childType = TypeUtils.getActualTypeForFirstTypeVariable((Type)typeOfF);
                for (JsonElement jsonChild : jsonArray) {
                    Object child = this.visitChild(childType, jsonChild);
                    if (childType == Object.class) {
                        throw new JsonParseException(fName + " can not be a raw collection. Try making it a genericized collection instead");
                    }
                    collection.add(child);
                }
            } else {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitArrayField(Field f, Type typeOfF, Object obj) {
        try {
            JsonObject jsonObject = this.json.getAsJsonObject();
            String fName = this.getFieldName(f);
            JsonArray jsonChild = (JsonArray)jsonObject.get(fName);
            if (jsonChild != null) {
                Object array = this.visitChildAsArray(typeOfF, jsonChild);
                f.set(obj, array);
            } else {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitPrimitiveField(Field f, Type typeOfF, Object obj) {
        try {
            JsonObject jsonObject = this.json.getAsJsonObject();
            String fName = this.getFieldName(f);
            JsonPrimitive value = jsonObject.getAsJsonPrimitive(fName);
            if (value != null) {
                f.set(obj, this.typeAdapter.adaptType(value.getAsObject(), TypeUtils.toRawClass((Type)typeOfF)));
            } else if (f.getType() == String.class) {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFieldName(Field f) {
        FieldNamingStrategy namingPolicy = this.factory.getFieldNamingPolicy();
        return namingPolicy.translateName(f);
    }
}

