/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.ObjectNavigator;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.Preconditions;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoArray;
import com.google.gson.TypeInfoFactory;
import com.google.gson.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonSerializationVisitor
implements ObjectNavigator.Visitor {
    private final ObjectNavigatorFactory factory;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final boolean serializeNulls;
    private final JsonSerializationContext context;
    private JsonElement root;

    JsonSerializationVisitor(ObjectNavigatorFactory factory, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, JsonSerializationContext context) {
        this.factory = factory;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.context = context;
    }

    public void endVisitingObject(Object node) {
    }

    public void startVisitingObject(Object node) {
        this.assignToRoot((JsonElement)new JsonObject());
    }

    public void visitArray(Object array, Type arrayType) {
        this.assignToRoot((JsonElement)new JsonArray());
        int length = Array.getLength(array);
        TypeInfoArray fieldTypeInfo = TypeInfoFactory.getTypeInfoForArray((Type)arrayType);
        Type componentType = fieldTypeInfo.getSecondLevelType();
        for (int i = 0; i < length; ++i) {
            Object child = Array.get(array, i);
            this.addAsArrayElement(componentType, child);
        }
    }

    public void visitCollection(Collection collection, Type collectionType) {
        this.assignToRoot((JsonElement)new JsonArray());
        for (Object child : collection) {
            Class<?> childType = TypeUtils.getActualTypeForFirstTypeVariable((Type)collectionType);
            if (childType == Object.class && child != null) {
                childType = child.getClass();
            }
            this.addAsArrayElement((Type)childType, child);
        }
    }

    public void visitArrayField(Field f, Type typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, (JsonElement)new JsonNull());
            }
        } else {
            Object array = this.getFieldValue(f, obj);
            this.addAsChildOfObject(f, typeOfF, array);
        }
    }

    public void visitCollectionField(Field f, Type typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, (JsonElement)new JsonNull());
            }
        } else {
            if (typeOfF == null) {
                throw new RuntimeException("Can not handle non-generic collections");
            }
            Object collection = this.getFieldValue(f, obj);
            this.addAsChildOfObject(f, typeOfF, collection);
        }
    }

    public void visitEnum(Object obj, Type objType) {
        JsonSerializer serializer = (JsonSerializer)this.serializers.getHandlerFor(objType);
        if (serializer == null) {
            serializer = (JsonSerializer)this.serializers.getHandlerFor(Enum.class);
        }
        if (serializer == null) {
            throw new RuntimeException("Register a JsonSerializer for Enum or " + obj.getClass().getName());
        }
        this.assignToRoot(serializer.serialize(obj, objType, this.context));
    }

    public void visitObjectField(Field f, Type typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, (JsonElement)new JsonNull());
            }
        } else {
            Object fieldValue = this.getFieldValue(f, obj);
            if (fieldValue != null && typeOfF == Object.class) {
                typeOfF = fieldValue.getClass();
            }
            this.addAsChildOfObject(f, (Type)typeOfF, fieldValue);
        }
    }

    private void addAsChildOfObject(Field f, Type fieldType, Object fieldValue) {
        JsonElement childElement = this.getJsonElementForChild(fieldType, fieldValue);
        this.addChildAsElement(f, childElement);
    }

    private void addChildAsElement(Field f, JsonElement childElement) {
        FieldNamingStrategy namingPolicy = this.factory.getFieldNamingPolicy();
        this.root.getAsJsonObject().add(namingPolicy.translateName(f), childElement);
    }

    private void addAsArrayElement(Type elementType, Object elementValue) {
        if (elementValue == null) {
            this.addNullAsArrayElement();
        } else {
            JsonElement childElement = this.getJsonElementForChild(elementType, elementValue);
            this.root.getAsJsonArray().add(childElement);
        }
    }

    private void addNullAsArrayElement() {
        this.root.getAsJsonArray().add(null);
    }

    private JsonElement getJsonElementForChild(Type fieldType, Object fieldValue) {
        ObjectNavigator on = this.factory.create(fieldValue, fieldType);
        JsonSerializationVisitor childVisitor = new JsonSerializationVisitor(this.factory, this.serializeNulls, this.serializers, this.context);
        on.accept((ObjectNavigator.Visitor)childVisitor);
        return childVisitor.getJsonElement();
    }

    public void visitPrimitiveField(Field f, Type typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, (JsonElement)new JsonNull());
            }
        } else {
            TypeInfo typeInfo = new TypeInfo(typeOfF);
            if (typeInfo.isPrimitiveOrStringAndNotAnArray()) {
                Object fieldValue = this.getFieldValue(f, obj);
                this.addAsChildOfObject(f, typeOfF, fieldValue);
            } else {
                throw new IllegalArgumentException("Not a primitive type");
            }
        }
    }

    public void visitPrimitiveValue(Object obj) {
        this.assignToRoot((JsonElement)new JsonPrimitive(obj));
    }

    public boolean visitUsingCustomHandler(Object obj, Type objType) {
        JsonSerializer serializer = (JsonSerializer)this.serializers.getHandlerFor(objType);
        if (serializer == null && obj instanceof Map) {
            serializer = (JsonSerializer)this.serializers.getHandlerFor(Map.class);
        }
        if (serializer != null) {
            this.assignToRoot(serializer.serialize(obj, objType, this.context));
            return true;
        }
        return false;
    }

    private void assignToRoot(JsonElement newRoot) {
        Preconditions.checkArgument((this.root == null ? 1 : 0) != 0);
        this.root = newRoot;
    }

    private boolean isFieldNull(Field f, Object obj) {
        return this.getFieldValue(f, obj) == null;
    }

    private Object getFieldValue(Field f, Object obj) {
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonElement getJsonElement() {
        return this.root;
    }
}

