/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.InstanceCreator;
import com.google.gson.ObjectConstructor;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeInfo;
import com.google.gson.TypeUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MappedObjectConstructor
implements ObjectConstructor {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreatorMap = new ParameterizedTypeHandlerMap();

    MappedObjectConstructor() {
    }

    public <T> T construct(Type typeOfT) {
        if (this.instanceCreatorMap.hasAnyHandlerFor(typeOfT)) {
            InstanceCreator creator = (InstanceCreator)this.instanceCreatorMap.getHandlerFor(typeOfT);
            return (T)creator.createInstance(typeOfT);
        }
        TypeInfo typeInfo = new TypeInfo(typeOfT);
        if (typeInfo.isEnum()) {
            InstanceCreator creator = (InstanceCreator)this.instanceCreatorMap.getHandlerFor(Enum.class);
            return (T)creator.createInstance(typeOfT);
        }
        return (T)this.constructWithNoArgConstructor(typeOfT);
    }

    public Object constructArray(Type type, int length) {
        return Array.newInstance(TypeUtils.toRawClass((Type)type), length);
    }

    private <T> T constructWithNoArgConstructor(Type typeOfT) {
        try {
            Constructor constructor = this.getNoArgsConstructor(typeOfT);
            if (constructor == null) {
                throw new RuntimeException("No-args constructor for " + typeOfT + " does not exist. " + "Register an InstanceCreator with Gson for this type to fix this problem.");
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to invoke no-args constructor for " + typeOfT + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to invoke no-args constructor for " + typeOfT + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to invoke no-args constructor for " + typeOfT + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", e);
        }
    }

    private <T> Constructor<T> getNoArgsConstructor(Type typeOfT) {
        TypeInfo typeInfo = new TypeInfo(typeOfT);
        Class clazz = typeInfo.getRawClass();
        AccessibleObject[] declaredConstructors = clazz.getDeclaredConstructors();
        AccessibleObject.setAccessible(declaredConstructors, true);
        for (AccessibleObject constructor : declaredConstructors) {
            if (((Constructor)constructor).getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    <T> void register(Type typeOfT, InstanceCreator<? extends T> creator) {
        if (this.instanceCreatorMap.hasSpecificHandlerFor(typeOfT)) {
            this.log.log(Level.WARNING, "Overriding the existing InstanceCreator for " + typeOfT);
        }
        this.instanceCreatorMap.register(typeOfT, creator);
    }

    public String toString() {
        return this.instanceCreatorMap.toString();
    }
}

