/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.GenericArrayTypeImpl;
import com.google.gson.ParameterizedTypeImpl;
import com.google.gson.Preconditions;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoArray;
import com.google.gson.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
final class TypeInfoFactory {
    private TypeInfoFactory() {
    }

    public static TypeInfoArray getTypeInfoForArray(Type type) {
        Preconditions.checkArgument((boolean)TypeUtils.isArray((Type)type));
        return new TypeInfoArray(type);
    }

    public static TypeInfo getTypeInfoForField(Field f, Type typeDefiningF) {
        Class classDefiningF = TypeUtils.toRawClass((Type)typeDefiningF);
        Type type = f.getGenericType();
        Type actualType = TypeInfoFactory.getActualType((Type)type, (Type)typeDefiningF, (Class)classDefiningF);
        return new TypeInfo(actualType);
    }

    private static Type getActualType(Type typeToEvaluate, Type parentType, Class<?> rawParentClass) {
        if (typeToEvaluate instanceof Class) {
            return typeToEvaluate;
        }
        if (typeToEvaluate instanceof ParameterizedType) {
            ParameterizedType castedType = (ParameterizedType)typeToEvaluate;
            Type owner = castedType.getOwnerType();
            Type[] actualTypeParameters = TypeInfoFactory.extractRealTypes((Type[])castedType.getActualTypeArguments(), (Type)parentType, rawParentClass);
            Type rawType = castedType.getRawType();
            return new ParameterizedTypeImpl(rawType, actualTypeParameters, owner);
        }
        if (typeToEvaluate instanceof GenericArrayType) {
            Type actualType;
            GenericArrayType castedType = (GenericArrayType)typeToEvaluate;
            Type componentType = castedType.getGenericComponentType();
            if (componentType.equals(actualType = TypeInfoFactory.getActualType((Type)componentType, (Type)parentType, rawParentClass))) {
                return castedType;
            }
            if (actualType instanceof Class) {
                return TypeUtils.wrapWithArray((Class)TypeUtils.toRawClass((Type)actualType));
            }
            return new GenericArrayTypeImpl(actualType);
        }
        if (typeToEvaluate instanceof TypeVariable) {
            TypeVariable fieldTypeVariable = (TypeVariable)typeToEvaluate;
            TypeVariable[] classTypeVariables = rawParentClass.getTypeParameters();
            ParameterizedType objParameterizedType = (ParameterizedType)parentType;
            int indexOfActualTypeArgument = TypeInfoFactory.getIndex((TypeVariable[])classTypeVariables, (TypeVariable)fieldTypeVariable);
            Type[] actualTypeArguments = objParameterizedType.getActualTypeArguments();
            return actualTypeArguments[indexOfActualTypeArgument];
        }
        if (typeToEvaluate instanceof WildcardType) {
            WildcardType castedType = (WildcardType)typeToEvaluate;
            return TypeInfoFactory.getActualType((Type)castedType.getUpperBounds()[0], (Type)parentType, rawParentClass);
        }
        throw new IllegalArgumentException("Type '" + typeToEvaluate + "' is not a Class, " + "ParameterizedType, GenericArrayType or TypeVariable. Can't extract type.");
    }

    private static Type[] extractRealTypes(Type[] actualTypeArguments, Type parentType, Class<?> rawParentClass) {
        Preconditions.checkNotNull((Object)actualTypeArguments);
        Type[] retTypes = new Type[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            retTypes[i] = TypeInfoFactory.getActualType((Type)actualTypeArguments[i], (Type)parentType, rawParentClass);
        }
        return retTypes;
    }

    private static int getIndex(TypeVariable<?>[] types, TypeVariable<?> type) {
        for (int i = 0; i < types.length; ++i) {
            if (!type.equals(types[i])) continue;
            return i;
        }
        throw new IllegalStateException("How can the type variable not be present in the class declaration!");
    }
}

