/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.Preconditions;
import com.google.gson.TypeInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

final class TypeInfoMap {
    private final ParameterizedType mapType;

    public TypeInfoMap(Type mapType) {
        if (!(mapType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Map objects need to be parameterized unless you use a custom serializer. Use the com.google.gson.reflect.TypeToken to extract the ParameterizedType.");
        }
        TypeInfo rawType = new TypeInfo(mapType);
        Preconditions.checkArgument((boolean)Map.class.isAssignableFrom(rawType.getRawClass()));
        this.mapType = (ParameterizedType)mapType;
    }

    public Type getKeyType() {
        return this.mapType.getActualTypeArguments()[0];
    }

    public Type getValueType() {
        return this.mapType.getActualTypeArguments()[1];
    }
}

