/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.allen_sauer.gwt.log.client.DivLogger;
import com.allen_sauer.gwt.log.client.Log;
import com.allen_sauer.gwt.log.client.Logger;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.InfoPanel;
import org.gwt.mosaic.ui.client.ScrollLayoutPanel;
import org.gwt.mosaic.ui.client.Viewport;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.util.ButtonHelper;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Authentication;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.Header;
import org.jboss.bpm.console.client.LoadingStatusAction;
import org.jboss.bpm.console.client.MainLayout;
import org.jboss.bpm.console.client.Menu;
import org.jboss.bpm.console.client.SettingsEditor;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.Workspace;
import org.jboss.bpm.console.client.WorkspaceLauncher;
import org.jboss.bpm.console.client.engine.UpdateDeploymentsAction;
import org.jboss.bpm.console.client.engine.ViewDeploymentAction;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.process.UpdateDefinitionsAction;
import org.jboss.bpm.console.client.util.WindowUtil;

public class MainLayout
extends Composite
implements ApplicationContext {
    public static final String NAME = "mainLayout";
    private Header header;
    private Menu menu;
    private Workspace workspace;
    private URLBuilder urlBuilder;
    private Authentication auth;
    private ConsoleConfig config;
    private Controller controller;
    private Viewport viewport;

    public MainLayout(Controller controller, Authentication auth, URLBuilder urlBuilder, ConsoleConfig config) {
        this.controller = controller;
        this.auth = auth;
        this.config = config;
        this.urlBuilder = urlBuilder;
        this.display();
    }

    public void display() {
        this.viewport = new Viewport();
        Log.addLogger((Logger)new DivLogger());
        LayoutPanel layout = this.createLayout();
        this.viewport.add((Widget)layout);
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(2000);
        RootPanel.get().add((Widget)this.viewport);
    }

    private LayoutPanel createLayout() {
        LayoutPanel layoutPanel = new LayoutPanel((LayoutManager)new BorderLayout());
        this.header = new Header((ApplicationContext)this, this.auth.getUsername(), this.auth.getRolesAssigned());
        layoutPanel.add((Widget)this.header, (LayoutData)new BorderLayoutData(BorderLayout.Region.NORTH, 50.0));
        this.menu = new Menu();
        layoutPanel.add((Widget)this.menu, (LayoutData)new BorderLayoutData(BorderLayout.Region.WEST, 200.0));
        this.workspace = this.createWorkspace();
        layoutPanel.add((Widget)this.workspace, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER, false));
        this.registerGlobalViewsAndActions();
        CaptionLayoutPanel messagePanel = this.createMessagePanel(layoutPanel);
        messagePanel.add(Log.getDivLogger().getWidget());
        messagePanel.setCollapsed(true);
        layoutPanel.add((Widget)messagePanel, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, true));
        Log.getDivLogger().getWidget().setVisible(true);
        if (this.workspace.hasEditor(SettingsEditor.ID)) {
            this.workspace.showEditor(SettingsEditor.ID);
        }
        return layoutPanel;
    }

    private void registerGlobalViewsAndActions() {
        this.controller.addView(Header.ID, (ViewInterface)this.header);
        this.controller.addAction(LoadingStatusAction.ID, (ActionInterface)new LoadingStatusAction());
        this.controller.addAction(ViewDeploymentAction.ID, (ActionInterface)new ViewDeploymentAction((ApplicationContext)this));
        this.controller.addAction(UpdateDeploymentsAction.ID, (ActionInterface)new UpdateDeploymentsAction((ApplicationContext)this));
        this.controller.addAction(UpdateDefinitionsAction.ID, (ActionInterface)new UpdateDefinitionsAction((ApplicationContext)this));
    }

    private CaptionLayoutPanel createMessagePanel(LayoutPanel layoutPanel) {
        CaptionLayoutPanel messagePanel = new CaptionLayoutPanel("Messages", true);
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        Button collapse = new Button(ButtonHelper.createButtonLabel((AbstractImagePrototype)icons.collapseDownIcon(), (String)"", (ButtonHelper.ButtonLabelType)ButtonHelper.ButtonLabelType.TEXT_ON_TOP));
        collapse.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        messagePanel.getHeader().add((Widget)collapse, Caption.CaptionRegion.RIGHT);
        return messagePanel;
    }

    private Workspace createWorkspace() {
        Workspace workspace = new Workspace(this.menu, (ApplicationContext)this);
        WorkspaceLauncher launcher = (WorkspaceLauncher)GWT.create(WorkspaceLauncher.class);
        launcher.launch((ApplicationContext)this, workspace);
        return workspace;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public Controller getController() {
        return this.controller;
    }

    public URLBuilder getUrlBuilder() {
        return this.urlBuilder;
    }

    public void displayMessage(String message, boolean isError) {
        if (isError) {
            ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
            WindowPanel err = new WindowPanel("Error");
            err.getHeader().add((Widget)icons.errorIcon().createImage());
            err.setAnimationEnabled(true);
            err.setSize("320px", "240px");
            ScrollLayoutPanel scrollLayoutPanel = new ScrollLayoutPanel();
            scrollLayoutPanel.add((Widget)new HTML(message));
            err.setWidget((Widget)scrollLayoutPanel);
            WindowUtil.addMaximizeButton((WindowPanel)err, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
            WindowUtil.addMinimizeButton((WindowPanel)err, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
            err.center();
        } else {
            InfoPanel.show((String)"", (String)message, (String[])new String[]{""});
        }
    }

    public Authentication getAuthentication() {
        return this.auth;
    }

    public ConsoleConfig getConfig() {
        return this.config;
    }

    public Workspace getWorkpace() {
        return this.workspace;
    }

    public void refreshView() {
        int width = Window.getClientWidth();
        int height = Window.getClientHeight();
        this.getViewport().onWindowResized(width, height);
    }
}

