/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.gwt.mosaic.ui.client.list.ListModel;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.ProcessDetailView;
import org.jboss.bpm.console.client.process.UpdateProcessDetailAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefinitionListView
extends AbstractView {
    public static final String ID = DefinitionListView.class.getName();
    private Controller controller;
    private LayoutPanel definitionList = null;
    private org.gwt.mosaic.ui.client.ListBox<ProcessDefinitionRef> listBox;
    private boolean isInitialized;
    private int FILTER_NONE = 10;
    private int FILTER_ACTIVE = 20;
    private int FILTER_SUSPENDED = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<ProcessDefinitionRef> definitions = null;

    public DefinitionListView() {
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.setTitle("Process Definitions");
        this.setIcon(icons.processIcon());
        this.listBox = this.createListBox();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.definitionList = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.definitionList.setPadding(0);
            this.definitionList.setWidgetSpacing(0);
            LayoutPanel toolBox = new LayoutPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(0);
            toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new ToolButton("Refresh", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            LayoutPanel filterPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            filterPanel.setStyleName("bpm-filter-panel");
            ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Active");
            dropBox.addItem("Suspended");
            dropBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.VERTICAL));
            this.definitionList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.definitionList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            LayoutPanel layout = new LayoutPanel((LayoutManager)new BorderLayout());
            layout.add((Widget)this.definitionList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            ProcessDetailView detailsView = new ProcessDetailView();
            this.controller.addView(ProcessDetailView.ID, (ViewInterface)detailsView);
            this.controller.addAction(UpdateProcessDetailAction.ID, (ActionInterface)new UpdateProcessDetailAction());
            layout.add((Widget)detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.add((Widget)layout);
            this.isInitialized = true;
        }
    }

    private org.gwt.mosaic.ui.client.ListBox createListBox() {
        org.gwt.mosaic.ui.client.ListBox listBox = new org.gwt.mosaic.ui.client.ListBox(new String[]{"Process ID", "Version", "Name", "Suspended"});
        listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        listBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        ListModel origModel = listBox.getModel();
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void update(List<ProcessDefinitionRef> definitions) {
        this.definitions = definitions;
        this.renderFiltered();
    }

    private void renderFiltered() {
        if (this.definitions != null) {
            DefaultListModel model = (DefaultListModel)this.listBox.getModel();
            model.clear();
            for (ProcessDefinitionRef def : this.definitions) {
                boolean showSuspended;
                if (this.FILTER_NONE == this.currentFilter) {
                    model.add((Object)def);
                    continue;
                }
                boolean bl = showSuspended = this.FILTER_SUSPENDED == this.currentFilter;
                if (def.isSuspended() != showSuspended) continue;
                model.add((Object)def);
            }
            if (this.listBox.getSelectedIndex() != -1) {
                this.listBox.setItemSelected(this.listBox.getSelectedIndex(), false);
            }
            this.controller.handleEvent(new Event(UpdateProcessDetailAction.ID, null));
        }
    }

    public ProcessDefinitionRef getSelection() {
        ProcessDefinitionRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = (ProcessDefinitionRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    static /* synthetic */ Controller access$000(DefinitionListView x0) {
        return x0.controller;
    }

    static /* synthetic */ int access$102(DefinitionListView x0, int x1) {
        x0.currentFilter = x1;
        return x0.currentFilter;
    }

    static /* synthetic */ int access$200(DefinitionListView x0) {
        return x0.FILTER_NONE;
    }

    static /* synthetic */ int access$300(DefinitionListView x0) {
        return x0.FILTER_ACTIVE;
    }

    static /* synthetic */ int access$400(DefinitionListView x0) {
        return x0.FILTER_SUSPENDED;
    }

    static /* synthetic */ void access$500(DefinitionListView x0) {
        x0.renderFiltered();
    }
}

