/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NamedNodeMap;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.process.InstanceDataView;
import org.jboss.bpm.console.client.util.ConsoleLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceDataView
extends LayoutPanel
implements ViewInterface,
LazyPanel {
    public static final String ID = InstanceDataView.class.getName();
    private Controller controller;
    private ListBox listBox;
    private String instanceId;
    private boolean isInitialized;

    public InstanceDataView() {
        this.setPadding(5);
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.listBox = new ListBox(new String[]{"Key", "XSD Type", "Java Type", "Value"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.add((Widget)this.listBox);
            this.isInitialized = true;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void update(String instanceId, Document xml) {
        this.instanceId = instanceId;
        this.parseMessage(xml);
    }

    private void parseMessage(Document messageDom) {
        try {
            Node dataSetNode = messageDom.getElementsByTagName("dataset").item(0);
            List dataSetNodeChildren = this.filterChildNodes(dataSetNode.getChildNodes());
            ArrayList<DataEntry> results = new ArrayList<DataEntry>();
            for (Node dataNode : dataSetNodeChildren) {
                DataEntry dataEntry = new DataEntry(this, null);
                NamedNodeMap dataNodeAttributes = dataNode.getAttributes();
                Node valueNode = (Node)this.filterChildNodes(dataNode.getChildNodes()).get(0);
                NamedNodeMap valueNodeAttributes = valueNode.getAttributes();
                dataEntry.key = dataNodeAttributes.getNamedItem("key").getNodeValue();
                dataEntry.java = dataNodeAttributes.getNamedItem("javaType").getNodeValue();
                dataEntry.xsd = valueNodeAttributes.getNamedItem("xsi:type").getNodeValue();
                List valueChildElements = this.filterChildNodes(valueNode.getChildNodes());
                dataEntry.value = valueChildElements.isEmpty() && valueNode.hasChildNodes() && 3 == valueNode.getChildNodes().item(0).getNodeType() ? valueNode.getFirstChild().getNodeValue() : "n/a";
                results.add(dataEntry);
            }
            this.bindData(results);
        }
        catch (Throwable e) {
            ConsoleLog.error((String)"Failed to parse XML document", (Throwable)e);
        }
    }

    private void bindData(List<DataEntry> data) {
        this.initialize();
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        for (DataEntry d : data) {
            model.add((Object)d);
        }
        this.layout();
    }

    private List<Node> filterChildNodes(NodeList childNodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1) continue;
            result.add(n);
        }
        return result;
    }
}

