/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Event;
import java.util.Date;
import java.util.List;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.model.util.SimpleDateFormat;
import org.jboss.bpm.console.client.task.AbstractTaskList;
import org.jboss.bpm.console.client.task.TaskDetailView;
import org.jboss.bpm.console.client.task.UpdateDetailsAction;
import org.jboss.bpm.console.client.task.events.DetailViewEvent;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.WindowUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignedTasksView
extends AbstractTaskList {
    public static final String ID = AssignedTasksView.class.getName();
    private final ApplicationContext appContext;
    private WindowPanel windowPanel;
    private Frame frame;
    private TaskDetailView detailsView;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private boolean hasDispatcherPlugin;

    public AssignedTasksView(ApplicationContext appContext, TaskDetailView detailsView) {
        this.appContext = appContext;
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.setTitle("Personal Tasks");
        this.setIcon(icons.userIcon());
        this.detailsView = detailsView;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.taskList = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.taskList.setPadding(0);
            this.taskList.setWidgetSpacing(0);
            this.listBox = new ListBox(new String[]{"Priority", "Process", "Task Name", "Due Date"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.listBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            LayoutPanel toolBox = new LayoutPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new ToolButton("Refresh", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.addSeparator();
            ToolButton viewBtn = new ToolButton("View", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            toolBar.add((Widget)viewBtn);
            toolBar.addSeparator();
            toolBar.add((Widget)new ToolButton("Release", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.taskList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.taskList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            LayoutPanel layout = new LayoutPanel((LayoutManager)new BorderLayout());
            layout.add((Widget)this.taskList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            layout.add((Widget)this.detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.add((Widget)layout);
            this.hasDispatcherPlugin = ServerPlugins.has((String)"org.jboss.bpm.console.server.plugin.FormDispatcherPlugin");
            viewBtn.setEnabled(this.hasDispatcherPlugin);
            this.isInitialized = true;
        }
    }

    private void createTaskFormWindow(TaskRef task) {
        this.windowPanel = new WindowPanel("Task Interface");
        this.windowPanel.setAnimationEnabled(true);
        this.windowPanel.setSize("320px", "240px");
        LayoutPanel layout = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        layout.setStyleName("bpm-window-layout");
        layout.setPadding(5);
        Label header = new Label("Process: " + task.getProcessId() + ", Task: " + task.getName());
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.windowPanel.addWindowCloseListener((WindowCloseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.frame = new Frame();
        DOM.setStyleAttribute((Element)this.frame.getElement(), (String)"border", (String)"none");
        this.frame.getElement().setId(String.valueOf(new Date().getTime()));
        ConsoleLog.debug((String)this.frame.getElement().toString());
        this.frame.setUrl(task.getUrl());
        layout.add((Widget)this.frame, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.windowPanel.setWidget((Widget)layout);
        WindowUtil.addMaximizeButton((WindowPanel)this.windowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        WindowUtil.addMinimizeButton((WindowPanel)this.windowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        this.windowPanel.center();
    }

    public void update(String identity, List<TaskRef> tasks) {
        this.identity = identity;
        this.initialize();
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        for (TaskRef task : tasks) {
            if (TaskRef.STATE.ASSIGNED != task.getCurrentState()) continue;
            model.add((Object)task);
        }
        this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("AssignedDetailView", null)));
        this.invalidate();
    }

    static /* synthetic */ SimpleDateFormat access$000(AssignedTasksView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ ApplicationContext access$100(AssignedTasksView x0) {
        return x0.appContext;
    }

    static /* synthetic */ void access$200(AssignedTasksView x0, TaskRef x1) {
        x0.createTaskFormWindow(x1);
    }

    static /* synthetic */ WindowPanel access$302(AssignedTasksView x0, WindowPanel x1) {
        x0.windowPanel = x1;
        return x0.windowPanel;
    }

    static /* synthetic */ Frame access$402(AssignedTasksView x0, Frame x1) {
        x0.frame = x1;
        return x0.frame;
    }
}

