/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.*;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.LayoutPopupPanel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Header extends LayoutPanel implements ViewInterface
{
  public final static String ID = Header.class.getName();

  private ApplicationContext appContext;
  private Controller controller;
  private Image loadingImage;

  // avoid flickering image
  final Timer turnOffLoading = new Timer() {
    public void run() {
      loadingImage.setVisible(false);
    }
  };

  public Header(ApplicationContext appContext, String username, List<String> roles)
  {
    super(new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
    this.setStyleName("bpm-header");

    this.appContext = appContext;

    createInfoPanel();
  }

  private void createInfoPanel()
  {

    // ----------- logo panel
    LayoutPanel logoPanel = new LayoutPanel(new BoxLayout());
    logoPanel.setStyleName("bpm-header-left");

    Image logo = new Image(appContext.getConfig().getLogo());
    logo.setHeight("50");    
    logoPanel.add(logo);
    
    // ----------- info panel
    HorizontalPanel infoPanel = new HorizontalPanel();
    infoPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
    infoPanel.setSpacing(5);
    infoPanel.setStyleName("bpm-header-right");

    LayoutPanel loadingImageContainer = new LayoutPanel();
    loadingImageContainer.setStyleName("bpm-loading-image");

    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);
    loadingImage = new Image("images/ajax-loader.gif");
    loadingImageContainer.add(loadingImage);
    
    setLoading(false);

    // account info
    Image img = icons.userIcon().createImage();
    img.addClickListener(
        new ClickListener()
        {

          public void onClick(Widget widget)
          {
            StringBuffer sb = new StringBuffer("<h3>User information</h3>");
            sb.append("- User: ").append(appContext.getAuthentication().getUsername()).append("<br/>");
            sb.append("- Logged in since: ").append(appContext.getAuthentication().getLoggedInSince()).append("<br/>");
            sb.append("- SID: ").append(appContext.getAuthentication().getSid()).append("<br/>");
            sb.append("- Roles: ").append(appContext.getAuthentication().getRolesAssigned()).append("<br/>");


            final LayoutPopupPanel popup = new LayoutPopupPanel(true);
            popup.setPopupPosition(
                widget.getAbsoluteLeft()-120,
                widget.getAbsoluteTop()+20
            );
            popup.setAnimationEnabled(true);
            popup.setSize("240px", "130px");
            HTML html = new HTML(sb.toString());
            html.setStyleName("bpm-user-info-popup");
            popup.add(html);
            popup.show();
          }
        }
    );
    HTML html = new HTML(appContext.getAuthentication().getUsername());

    Button btn = new Button("Logout", new ClickListener()
    {

      public void onClick(Widget widget)
      {
        appContext.getAuthentication().logoutAndReload();
      }
    }
    );
    
    infoPanel.add(loadingImageContainer);
    infoPanel.add(img);
    infoPanel.add(html);
    infoPanel.add(btn);

    this.add(logoPanel, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
    this.add(infoPanel, new BoxLayoutData(177, 50));
  }


  public void setController(Controller controller)
  {
    this.controller = controller;
  }

  public void setLoading(boolean doDisplay)
  {
    if(doDisplay)
      loadingImage.setVisible(doDisplay);
    else
      turnOffLoading.schedule(1000);
  }
}
