/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Grid;
import com.mvc4g.client.Event;
import org.gwt.mosaic.ui.client.*;
import org.gwt.mosaic.ui.client.layout.*;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.common.HeaderLabel;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class SettingsEditor extends Editor
{

  public final static String ID = SettingsEditor.class.getName();

  private TabLayoutPanel tabPanel;

  private DeckLayoutPanel deck;

  public SettingsEditor(ApplicationContext appContext)
  {
    super(appContext);
  }

  public void initialize()
  {
    if(!isInitialized())
    {

      tabPanel = new DecoratedTabLayoutPanel();
      tabPanel.setPadding(5);

      deck = new DeckLayoutPanel();

      deck.add( createSystemPanel());
      deck.add( createPrefPanel());

      tabPanel.add(deck, "Settings");

      this.add(tabPanel, new BorderLayoutData(BorderLayout.Region.CENTER));

      appContext.refreshView();
      
      isInitialized = true;
    }

  }

  public void showView(String viewId)
  {
    if(viewId==null || viewId.equals("system"))
      deck.showWidget(0);
    else if(viewId.equals("preferences"))
      deck.showWidget(1);
    else
      throw new IllegalArgumentException("Unknown viewId: "+viewId);

    layout();
  }

  private CaptionLayoutPanel createPrefPanel()
  {
    PreferencesView prefView = new PreferencesView();
    controller.addView(PreferencesView.ID, prefView);
    
    return prefView;
  }

  private CaptionLayoutPanel createSystemPanel()
  {
    final CaptionLayoutPanel captionPanel = new CaptionLayoutPanel("System Settings");    

    LayoutPanel layoutPanel = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.VERTICAL));

    // console info
    Label console = new Label("Console Info");    
    layoutPanel.add(console, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

    Grid g1 = new Grid(1,2);
    g1.setWidget(0,0, new HTML("Version:"));
    g1.setWidget(0,1, new HTML(Version.VERSION));
    g1.getColumnFormatter().setWidth(0, "20%");

    layoutPanel.add(g1, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

    // server info
    Label server = new Label("Server Info");
    layoutPanel.add(server, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

    ServerStatusView serverStatus = new ServerStatusView(appContext);
    serverStatus.initialize();

    Grid g2 = new Grid(1,2);
    g2.setWidget(0,0, new HTML("Host:"));
    g2.setWidget(0,1, new HTML(appContext.getConfig().getConsoleServerUrl()));

    g2.getColumnFormatter().setWidth(0, "20%");

    layoutPanel.add(g2, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

    LayoutPanel pluginPanel = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.VERTICAL));
    pluginPanel.setPadding(0);
    Label label = new Label("Plugins:");

    pluginPanel.add(label);
    pluginPanel.add(serverStatus);

    layoutPanel.add(pluginPanel, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

    // view and actions
    super.controller.addView(ServerStatusView.ID, serverStatus);

    captionPanel.add(layoutPanel);
    return captionPanel;
  }

  public String getEditorId()
  {
    return ID;
  }

  public String getTitle()
  {
    return "Settings";
  }

  public MenuSection provideMenuSection()
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    return new MenuSection(
        getTitle(),
        icons.settingsIcon(),
        new SettingsEditorNavigation(appContext)
    );

  }
}
